/**********************************************************************************
*   this file is part of c2h
*   Copyright (C)2005 Bruce Park ( jongsuknim@naver.com )
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation; either
*   version 2 of the License, or (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************************/
#include "general.h"
#include "routines.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>

#include "makehtml.h"
#include "filelist.h"
#include "main.h"
#include "option.h"
#include "debug.h"
#include "keyword.h"
#include "option.h"
#include "taglist.h"

#include "htmlprocess.h"
#include "pltable.h"

#include "c2h_cmt.h"



typedef enum Dlmtid{ NOT_IDENT, LINE_CMT, 
    BLOCK_CMT_ON , BLOCK_CMT_OFF, KEYWORD_BLOCK_ON, KEYWORD_BLOCK_OFF,
    REGEXP_ON, REGEXP_MIDDLE, REGEXP_OFF,
    STRING_ON, STRING_OFF, ESCAPE_CHAR, 
    NEW_LINE, IN_CMT_NEW_LINE, IN_STRING_NEW_LINE , IN_REGEXP_NEW_LINE }dlmt_id;

extern void font_begin( font_type ftype,  const char *size, const char *color,
			const char *style, FILE *fout )
{  
    switch( option.html_type ){
	case HtmlType:
	    if( size == NULL && color == NULL && style == NULL )
		return;

	    fprintf( fout,"<font ");
	    if( size != NULL )
		fprintf( fout,"size=%s ",size);
	    if( color != NULL )
		fprintf( fout,"color=%s ",color);
	    if( style != NULL )
		fprintf( fout,"style=%s ",style);
	    fprintf( fout,">");

	    break;
	case CssType:
	case DhtmlType:
	    switch( ftype ){
		case Basic:
		    fprintf( fout, "<font class=\"Basic\">");
		    break;
		case Cmt:
		    fprintf( fout, "<font class=\"Cmt\">");
		    break;
		case String:
		    fprintf( fout, "<font class=\"String\">");
		    break;
		case Keyword:
		    fprintf( fout, "<font class=\"Keyword\">");
		    break;
		case Keyword1:
		    fprintf( fout, "<font class=\"Keyword1\">");
		    break;
		case Keyword2:
		    fprintf( fout, "<font class=\"Keyword2\">");
		    break;
		case Tag:
		    fprintf( fout, "<font class=\"Tag\">");
		    break;
		case Index:
		    fprintf( fout, "<font class=\"Index\">");
		    break;
	    }
	    break;
    }
}

extern void font_end(FILE *fout)    
{
    switch( option.html_type ){
	case HtmlType:
	    fprintf( fout,"</font>");
	    break;
	case CssType:
	case DhtmlType:
	    fprintf( fout,"</font>");
	    break;
    }
}

static boolean is_delimiter( char c, const char *dlmt)
{
    int i;
    for( i = 0 ; dlmt[i] != 0; i++ ){
	if( c == dlmt[i] )
	    return TRUE;
    }
    return FALSE;
}

static boolean char_match( const char *const token, const char *char_list)
{
    int i;
    for( i = 0 ; char_list[i] != 0 ; i++ ){
	if( char_list[i] == token[0] )
	    return TRUE;
    }
    return FALSE;
}


/*
   tokenó  string 
   string_list string Ͱ ġϸ ġ token ڼ 
   ׷   0 
*/
static int string_match( const char *const token, const char * const * string_list)
{
    int i,j;
    for( i =0 ; string_list[i] != NULL ; i++ ){
	for( j =0; token[j] == string_list[i][j]  ; j++ ){
	    /*token '\0'   string_list '\0' */
	    if( string_list[i][j] == '\0')
		return j;
	}
	/*string_list '\0'   */
	if( string_list[i][j] == '\0')
	    return j;
    }
    return 0;
}

static boolean keyword_match( const char *const token, const char * const * string_list , boolean dont_care )
{
    int i;
    if( dont_care ){
	for( i = 0 ; string_list[i] != 0; i++ ){
	    if( struppercmp( token, string_list[i]) == 0 )
		return TRUE;
	}
    }
    else {
	for( i = 0 ; string_list[i] != 0; i++ ){
	    if( strcmp( token, string_list[i]) == 0 )
		return TRUE;
	}
    }
    return FALSE;
}

static int dlmt_strcmp( const char *const token, const char *string )
{
    int i=0;
    while( string[i] != '\0' )
    {
	if( token[i] != string[i] )
	    return 0;
	else
	    i++;
    }
    return i;
}


boolean in_line_cmt = FALSE, in_block_cmt = FALSE, in_string = FALSE ;
boolean in_keyword_block = FALSE;
boolean in_regexp = FALSE;
boolean in_element = FALSE;

char begin_string_char= '\0';
char begin_regexp_char= '\0';

static int regexp_depth = 0;
static boolean next_escape = FALSE;
static int line=1;

static boolean c2h_cmt_process( FILE *fin, FILE *fout, char *token)
{
    char *ptr;
    char *newline;
    static boolean in_c2h_cmt = FALSE;
    int len = strlen( C2H_CMT_ON);
    if( strncmp( token, C2H_CMT_ON , len) == 0 )
    {
	in_c2h_cmt = TRUE;
	ungets( token + len, fin );
	//fputs( "</pre>", fout );
	return 1;
    }
    else if( strncmp( token, C2H_CMT_OFF , len) == 0 ) 
    {
	in_c2h_cmt = FALSE;
	ungets( token + len, fin );
	//fputs( "<pre>", fout );
	return 1;
    }
    /*
    TODO:
	  token C2H_CMT_ON C2H_CMT_OFF   ִٸ   ʴ´.
	   ڱ ̴.
     */
    else if( (ptr = strstr( token, C2H_CMT_ON )) != NULL ||
	      (ptr = strstr( token, C2H_CMT_OFF )) != NULL )
    {
	ungets( ptr, fin );
	*ptr='\0';
	if( in_c2h_cmt ){
	    newline = token;
	    while(( newline =strchr( newline, '\n' ) )!= NULL ){
		line++;
		newline++;
	    }
	    fputs( token, fout );
	return 1;

	}else
	    return 0;
    }
    else if( in_c2h_cmt )
    {
	newline = token;
	while(( newline =strchr( newline, '\n' ) )!= NULL ){
	    line++;
	    newline++;
	}
	fputs( token, fout );
	return 1;
    }
    else
	return 0;
}


static dlmt_id dlmt_ident( const char *const token, PL *pl_info , int *i )
{
    dlmt_id retval;
    boolean now_escape;

    now_escape	= next_escape;
    next_escape = FALSE;


    in_element = FALSE;

    if( token[0] == '\n' )
    {
	line++;
//	if( in_line_cmt ){
//	    in_line_cmt = FALSE;
//	}
	retval = NEW_LINE;
	*i = 1;
    }
    else if( pl_info->element_divide_string != NULL &&
	    (*i = string_match( token, pl_info->element_divide_string )))
    {
	in_element = TRUE;
	retval = NOT_IDENT;
    }
    else if( pl_info->keyword_block_on != NULL && 
	    (*i = string_match( token, pl_info->keyword_block_on)))
    {
	retval = KEYWORD_BLOCK_ON;
    }

    else if( pl_info->keyword_block_off != NULL && 
	    (*i = string_match( token, pl_info->keyword_block_off)))
    {
	retval = KEYWORD_BLOCK_OFF;
    }

    else if( pl_info->double_regexp_on != NULL && !in_regexp &&
	    (*i = string_match( token, pl_info->double_regexp_on)))
    {
	if( now_escape ){
	    retval = NOT_IDENT;
	    *i = 1;
	}
	else{
	    retval = REGEXP_ON;
	    begin_regexp_char = token[*i - 1];
	    regexp_depth = 2;
	}
    }

    else if( pl_info->single_regexp_on != NULL && !in_regexp &&
	    (*i = string_match( token, pl_info->single_regexp_on)))
    {
	if( now_escape ){
	    retval = NOT_IDENT;
	    *i = 1;
	}
	else{
	    retval = REGEXP_ON;
	    begin_regexp_char = token[*i - 1];
	    regexp_depth = 1;
	}
    }

    else if( pl_info->regexp_off != NULL && in_regexp &&
	    (*i = string_match( token, pl_info->regexp_off)))
    {
	Assert( *i == 1 );
	if( now_escape )
	    retval = NOT_IDENT;
	else if(  begin_regexp_char == token[0] ){
	    regexp_depth--;
	    if( regexp_depth == 1 )
		retval = REGEXP_MIDDLE;
	    else {
		begin_regexp_char	= '\0';
		retval = REGEXP_OFF;
	    }
	}else
	    retval = NOT_IDENT;
    }

    else if( pl_info->string_chars != NULL &&
	    char_match( token, pl_info->string_chars))
    {
	if( now_escape )	
	    retval = NOT_IDENT;
	else if( !in_string){
	    begin_string_char = token[0];
	    retval = STRING_ON;
	} else{
	    if( begin_string_char == token[0]){
		begin_string_char = '\0';
		retval = STRING_OFF;
	    }else
		retval = NOT_IDENT;
	}
	*i = 1;
    }

    else if( pl_info->escape_char != NULL &&
	    char_match( token, pl_info->escape_char))
    {
	if( now_escape == TRUE )
	    retval = NOT_IDENT;
	else{
	    next_escape = TRUE;
	    retval = ESCAPE_CHAR;
	}
	*i = 1;
    }

    else if( pl_info->line_cmt != NULL && 
	    (*i = dlmt_strcmp( token , pl_info->line_cmt )) )
    {
	retval = LINE_CMT;
    }

    else if( pl_info->block_cmt_on != NULL &&
	    (*i = string_match( token, pl_info->block_cmt_on)))
    {
	retval = BLOCK_CMT_ON;
    }

    else if( pl_info->block_cmt_off != NULL &&
	    (*i = string_match( token, pl_info->block_cmt_off)))
    {
	retval = BLOCK_CMT_OFF;
    }

    else
    {
	retval = NOT_IDENT;
	*i  = 1;
    }


    if( in_line_cmt && retval != NEW_LINE )
	return NOT_IDENT;

    else if( in_regexp &&  retval != REGEXP_OFF && retval != REGEXP_MIDDLE){
	if( option.n && retval == NEW_LINE )
	    return IN_REGEXP_NEW_LINE;
	else	
	    return NOT_IDENT;
    }
    else if( in_block_cmt &&  retval != BLOCK_CMT_OFF ){
	if( option.n && retval == NEW_LINE )
	    return IN_CMT_NEW_LINE;
	else	
	    return NOT_IDENT;
    }
    else if( in_string &&  retval != STRING_OFF){
	if( option.n && retval == NEW_LINE )
	    return IN_STRING_NEW_LINE;
	else 
	    return NOT_IDENT;
    }
    else
	return retval;
}


static dlmt_id dlmt_process(const char *token, PL *pl_info, FILE *fout )
{
    boolean set_end_font = FALSE;
    dlmt_id id;
    int i=0;
    int ptr = i;
    int len;
    char buf[BUF_MAX];


    len = strlen( token );
    while(ptr < len)
    {
	id = dlmt_ident( &token[ptr], pl_info, &i );
	switch( id ){
	    case LINE_CMT:
		in_line_cmt	 = TRUE;
		font_begin( Cmt, conf.cmt_size, conf.cmt_color, conf.cmt_style, fout );
		break;

	    case REGEXP_ON:
		in_regexp = TRUE;
		font_begin( String, conf.string_size, conf.string_color, conf.string_style, fout );
		break;
	    case REGEXP_MIDDLE:
	//	set_end_font = TRUE;
		break;
	    case REGEXP_OFF:
		in_regexp = FALSE;
		set_end_font = TRUE;
		break;

	    case BLOCK_CMT_ON:
		in_block_cmt = TRUE;
		font_begin( Cmt, conf.cmt_size, conf.cmt_color, conf.cmt_style, fout );
		break;

	    case BLOCK_CMT_OFF:
		in_block_cmt = FALSE;
		set_end_font = TRUE;
		break;

	    case KEYWORD_BLOCK_ON:
		in_keyword_block = TRUE;
		font_begin( Keyword, conf.keyword_size, conf.keyword_color, conf.keyword_style, fout );
		break;

	    case KEYWORD_BLOCK_OFF:
		if( in_keyword_block ){
		    in_keyword_block = FALSE;
		    set_end_font = TRUE;
		}
		break;

	    case STRING_ON:
		in_string = TRUE;
		font_begin( String,  conf.string_size, conf.string_color, conf.string_style, fout );
		break;

	    case STRING_OFF:
		in_string = FALSE;
		set_end_font = TRUE;
		break;

	    case ESCAPE_CHAR:
		break;

	    case NEW_LINE	    :
		if( in_line_cmt ){
		    set_end_font = TRUE;
		    in_line_cmt = FALSE;
		}
		break;

	    case IN_CMT_NEW_LINE    :
	    case IN_STRING_NEW_LINE :
	    case IN_REGEXP_NEW_LINE:
		if( option.n )
		    set_end_font = TRUE;
		break;

	    default:
		break;
	}

	if( i == 1 ){
	    if(token[ptr] == '<')
		sprintf( buf, "&lt;");
	    else if( token[ptr] == '>' )
		sprintf( buf, "&gt;");
	    else if( token[ptr] == '&' )
		sprintf( buf, "&amp;");
	    else if( token[ptr] == '\t' )
		sprintf( buf,"        ");
	    else{
		buf[0] = token[ptr];
		buf[1] = '\0';
	    }
	}
	else{
	    strncpy( buf, &token[ptr], i );
	    buf[i] = '\0';
	}
	/*
	 * Ʒ κ   line  ε,
	 * line  ؾ ϱ  ̸ ķ font
	 *  ؾ Ѵ. 
	 */
	
	fputs( buf, fout );
	if( set_end_font ){
	    set_end_font = FALSE;
	    font_end(fout);
	}

	/*line number print*/
	if( (id == NEW_LINE || id == IN_CMT_NEW_LINE 
		    || id == IN_STRING_NEW_LINE || id == IN_REGEXP_NEW_LINE)
		&& option.n )
	{
	    fprintf(fout,"%5d ", line );
	    if( id == IN_CMT_NEW_LINE ){
		font_begin( Cmt,  conf.cmt_size, conf.cmt_color, conf.cmt_style, fout );
	    }else if( id == IN_STRING_NEW_LINE){
		font_begin( String, conf.string_size, conf.string_color, conf.string_style, fout );
	    }else if( id == IN_REGEXP_NEW_LINE ){
		font_begin( String, conf.string_size, conf.string_color, conf.string_style, fout );
	    }
	}
	ptr += i;
    }
    next_escape = FALSE;
    return id;
}

/*
   ó  char   token .
   if (ù char == и) then ӵ и  
   else ӵ keyword 
    exception_rule  ִ 쿣  Ģ   Ѵ.
*/
static int get_token( FILE *fd, const char *const dlmt , char *token)
{
    int c,i;
    i=0;

    if( (c = fgetc(fd)) < 0 )
	return -1;

    token[i++] = (char)c;
    if( is_delimiter( (char)c, dlmt )){
	while( (c = fgetc(fd)) > 0 ){
	    if( is_delimiter((char)c, dlmt))
		token[i++] = (char)c;
	    else{
		ungetc( c, fd);
		break;
	    }
	}
	token[i] = '\0';
	return 1;
    }

    while( (c = fgetc(fd)) > 0 )
    {
	if( is_delimiter( (char)c, dlmt )) {
	    ungetc( c, fd );
	    break;
	}else
	    token[i++] = (char)c;
    }
    token[i] = '\0';
    return 0;
}

extern void file_process(file_entry *f)
{
    FILE *fin, *fout; 
    char buf[BUF_MAX];
    char opt_buf[BUF_MAX];
    char token[BUF_MAX];
    char *tmp, *ptr;
    lang_type l;
    const entryContent *content;
    dlmt_id id;
    int is_dlmt;
    int result;
    char c;

    l = f->language;
    fin = fopen( f->absolute_fname, "r" ); 
    if( fin == NULL )
	error( FATAL, "file open error %s %s %d\n", 
		f->absolute_fname, __FILE__, __LINE__ );

    sprintf( buf, "%s%s%s.html", TMP_DIR, html_name, f->relative_fname );
    fout = fopen(buf , "w"); 
    if( fout == NULL )
	error( FATAL, "file open error %s %s %d\n", 
		buf, __FILE__, __LINE__ );

    switch( option.html_type ){
	case HtmlType:
	    fprintf( fout, "<html><head><title>%s</title>\n</head>\n<body bgcolor=\"%s\">\n",
		    f->relative_fname , conf.bg_color );
	    break;
	case CssType:
	    fprintf( fout, "<html><head><title>%s</title>\n", f->relative_fname ); 
	    fprintf( fout, "<link rel=\"stylesheet\" type=\"text/css\" href=\"%sc2h.css\">" , f->path_upto_htmldir);
	    fprintf( fout, "</head><body>\n");
	    fprintf( fout, "<script type=\"text/javascript\" src=\"c2h.js\"></script>");
	    break;
	case DhtmlType:
	    fprintf( fout, "<html><head><title>%s</title>\n", f->relative_fname ); 
	    fprintf( fout, "<link rel=\"stylesheet\" type=\"text/css\" href=\"%stooltip.css\">" , f->path_upto_htmldir);
	    fprintf( fout, "<link rel=\"stylesheet\" type=\"text/css\" href=\"%sc2h.css\">" , f->path_upto_htmldir);
	    fprintf( fout, "<script type=\"text/javascript\" src=\"%stooltip_path.js\"></script>", f->path_upto_htmldir);
	    fprintf( fout, "</head><body>\n");
	    fprintf( fout, "<script type=\"text/javascript\" src=\"%stooltip.js\"></script>", f->path_upto_htmldir);
	    break;
    }
    fputs( "<pre>\n", fout);

    if( option.n )
	fprintf(fout,"%5d ",1);


    /*
     * get_token  ؼ token ´.  token delimiter ̰ų Ǵ
     * ܾ ̴.
     * ּ ڳ, ڿ ۹  delimiter ̱ , ̵ dlmt_process óѴ. 
     * tag ũ  ܾ ̱    óѴ.  
     * ̰   Ǹ    ruby 쿣 ּ  ڰ
     * =begin delimiter ڰ   ȴ. 
     * ̷ ͵ ó ؼ   exception_ruleԼ  ϰ ȴ. 
     * Ư ԽĿ ̷ 츦   ִµ,  , s/ s#  ð Խ ó ؾ 
     * ϱ  ̷͵ óϰ ȴ.  
     */
    while((is_dlmt = get_token( fin, pl_table[l].delimiters, token)) >= 0 )
    {
	
	if( pl_table[l].exception_rule != NULL )
	     is_dlmt = pl_table[l].exception_rule( fin, token , is_dlmt , fout);

	if( is_dlmt )
	{
	    if( c2h_cmt_process( fin , fout , token ) )
		continue;
	    id = dlmt_process( token, &pl_table[l], fout);
	}
	else if( in_line_cmt || in_block_cmt || in_string || in_regexp )
	{
	    fputs( token, fout );
	}
	else
	{
	    if(( result = lookupKeyword( token, line, f->status->name , l, &content, in_element )) != 0 )
	    {
		if( result == 2 ){/*if itself*/
		    fprintf( fout, "<a name=\"%s%d\">%s</a>", token, content->value , token );
		}
		else{
		    buf[0] = '\0';
		    opt_buf[0] = '\0';

		    switch( option.html_type ){
			case HtmlType:
			    break;
			case CssType:
			    if( conf.is_dir_exist ){
				tmp = get_dir_name(content->source);
				//fprintf( stderr, "%s   %s   %s\n", content->source, tmp , tmp2 );
				sprintf( buf," onClick=\"top.dir.location.href = \'%s%sdir_index.html#%s\'; ", 
					    f->path_upto_htmldir, tmp, baseFilename( content->source ) );
				eFree(tmp);
				strcat( opt_buf, buf );
			    }
			    if( conf.is_taglist_exist ){
				sprintf( buf,"top.taglist.location.href = \'%staglist.html#%s%d\'\" ", 
					f->path_upto_htmldir, token, content->value);
				strcat( opt_buf, buf );
			    }
			    break;
			case DhtmlType:
			    sprintf( opt_buf, " onClick=\"");
			    c = ' ';
			    if( conf.is_dir_exist) {
				tmp = get_dir_expend_id( content->source );
				sprintf( buf," javascript:top.dir.expandFolder('%s')", tmp);
				eFree(tmp);
				strcat( opt_buf, buf );
				c = ';';
			    }
			    if( conf.is_taglist_exist ){
				sprintf( buf,"%ctop.taglist.location.href = \'%staglist.html#%s%d\'\" ", 
					c, f->path_upto_htmldir, token, content->value);
				strcat( opt_buf, buf );
			    }
			    
			    tmp = relativeFilename( content->source, f->relative_dir );
			    ptr = (char*)get_base_file( tmp );
			    if( ptr != tmp ){
				*(ptr - 1) = '\0';
				sprintf( buf, " onMouseover=\"ddrivetip(\'%s/<br>%s<br><i><font color=red>%s %s\
				    </i></font>\')\"; onMouseout=\"hideddrivetip()\"",
					(strcmp(tmp,get_base_file(f->status->name))==0)? "":tmp, ptr,
					(content->struct_name == NULL )? "":content->struct_name, 
					get_type_name(l, content->type )); 
			    }else{
				sprintf( buf, " onMouseover=\"ddrivetip(\'%s<br><i><font color=red>\
				    %s %s</i></font>\')\"; onMouseout=\"hideddrivetip()\"",
					(strcmp(tmp,get_base_file(f->status->name))==0)? "":tmp, 
					(content->struct_name == NULL )? "":content->struct_name, 
					get_type_name(l, content->type )); 
			    }
			    //fprintf( stderr,"%s %s %s \n", content->source, f->relative_dir, tmp );
			    eFree( tmp );
			    strcat( opt_buf, buf );
			    break;
		    }
		    fprintf(fout,"<a href=\"%s%s.html#%s%d\" %s>%s</a>",
			    f->path_upto_htmldir, content->source, token, content->value, opt_buf, token );
		}
	    }
	    else if( pl_table[l].keywords != NULL &&
		    keyword_match( token, pl_table[l].keywords, pl_table[l].dont_care))
	    {
		font_begin( Keyword, conf.keyword_size, conf.keyword_color, conf.keyword_style, fout );
		fputs( token, fout );
		font_end(fout);
	    }
	    else if( pl_table[l].keywords1 != NULL &&
		    keyword_match( token, pl_table[l].keywords1, pl_table[l].dont_care))
	    {
		font_begin( Keyword1, conf.keyword1_size, conf.keyword1_color, conf.keyword1_style, fout );
		fputs( token, fout );
		font_end(fout);
	    }
	    else if( pl_table[l].keywords2 != NULL &&
		    keyword_match( token, pl_table[l].keywords2, pl_table[l].dont_care))
	    {
		font_begin( Keyword2, conf.keyword2_size, conf.keyword2_color, conf.keyword2_style, fout );
		fputs( token, fout );
		font_end(fout);
	    }
	    else 
		fputs( token, fout );
	}
    }

    fputs( "\n</pre>\n", fout);
    fputs("</body>\n</html>\n", fout);

    fclose(fin);
    fclose(fout);

    in_line_cmt	    = FALSE;
    in_block_cmt    = FALSE;
    in_string	    = FALSE;
    next_escape  = FALSE;
    line = 1;
    return;
}

extern void ignore_process(file_entry *f)
{
    FILE *fin, *fout; 
    char buf[BUF_MAX];
    int c;
    fin = fopen( f->absolute_fname, "r" ); 
    if( fin == NULL )
	error( FATAL, "file open error %s %s %d\n", 
		f->absolute_fname, __FILE__, __LINE__ );

    sprintf( buf, "%s%s%s.html", TMP_DIR, html_name, f->relative_fname );
    fout = fopen(buf , "w"); 
    if( fout == NULL )
	error( FATAL, "file open error %s %s %d\n", 
		buf, __FILE__, __LINE__ );

    fprintf( fout, "<html><head><title>%s</title>\n</head>\n<body bgcolor=\"%s\">\n<pre>\n", 
	    f->relative_fname , conf.bg_color);
    while( ( c = fgetc(fin)) != EOF ){
	if(c == '<')
	    fputs( "&lt;", fout);
	else if( c == '>' )
	    fputs( "&gt;", fout);
	else if( c == '&' )
	    fputs( "&amp;", fout);
	else{
	    fputc(c,fout);
	}
    }
    fputs( "\n</pre>\n</body>\n</html>\n", fout);

    fclose(fin);
    fclose(fout);
}
