/**********************************************************************************
*   this file is part of c2h
*   Copyright (C)2005 Bruce Park ( jongsuknim@naver.com )
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation; either
*   version 2 of the License, or (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************************/
#include "general.h"
#include "keyword.h"
#include "routines.h"
#include "debug.h"
#include "pltable.h"
#include "filelist.h"
#include "makehtml.h"
#include "main.h"
#include "option.h"
#include "taglist.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <dirent.h>


#define IMG_DIR	    "img"

char *binary_dirs;

static void binary_dir_process()
{
    char cmd[BUF_MAX];
    if( binary_dirs == NULL )
	return;
    sprintf( cmd, "cp -R %s %s",binary_dirs , tmp_html_dir );
    if( system(cmd ) < 0 )
	error( FATAL, "%s error\n", cmd );
    return;
}

static void copy_data()
{
    char cmd[BUF_MAX];

    sprintf( cmd, "cp $C2HDIR/data/img/* %s", html_name );
    if( system(cmd) < 0 )
	error( FATAL, "data copy error %s %d\n", __FILE__, __LINE__ );

    switch( option.html_type ){
	case HtmlType:
	    cmd[0] = '\0';
	    break;
	case CssType:
	    sprintf( cmd, "cp $C2HDIR/data/csstype/* %s", html_name );
	    break;
	case DhtmlType:
	    sprintf( cmd, "cp $C2HDIR/data/dhtmltype/* %s;echo 'var tooltipimg_path=\"%s\";'> %s/tooltip_path.js;",
		    html_name, html_dir, html_name  );
	    break;
    }
    if( system(cmd) < 0 )
	error( FATAL, "copy error %s %d\n", __FILE__, __LINE__ );
}

static boolean is_ignore_type( char type, lang_type l )
{
    int i;
    if( pl_table[l].ignore_type == NULL )
	return FALSE;
    for( i =0 ; pl_table[l].ignore_type[i] != '\0'; i++ )
	if( type == pl_table[l].ignore_type[i] )
	   return TRUE;
    return FALSE;
}

static void init_keyword(FILE *fd, scope s)
{
    char buf[BUF_MAX];
    char *token;
    char *keyword, *source, *struct_name = NULL;
    char type;
    const char *file_extension;
    int line;
    lang_type lang;
    int value;
    scope real_s;

    sprintf( buf,"%s%s",TMP_DIR, taglist_name);
    /*
       taglist Ư global 쿡 ۼѴ.
       taglist κп  Ű常 .
     */
    if( s == Global )
	init_tag_list(buf);

    while( fgets( buf, BUF_MAX, fd) != NULL)
    {
	token = strtok( buf, (const char*)" \t");
	Assert( token != NULL );
	keyword = eStrdup(token);

	token = strtok( NULL, (const char*)" \t");
	Assert( token != NULL );
	source = eStrdup(token);

	token = strtok( NULL, (const char*)" \t");
	Assert( token != NULL );
	type = *token;

	token = strtok( NULL, (const char*)" \t");
	Assert( token != NULL );
	line = atoi(token);

	token = strtok( NULL, (const char*)" \t\n");
	Assert( token != NULL );

	file_extension  = fileExtension( source );
	lang = get_lang_type_with_extension( file_extension );
	if( lang == Ignore )
	    lang = get_lang_type_with_content(source);
	if( is_ignore_list(lang))
	    lang = Ignore;

	token = strtok( NULL, (const char*)" \t\n:");
	if( token != NULL ){
	    token = strtok( NULL, (const char*)" \t\n:");
	    if( token != NULL ){
		struct_name = eStrdup( token );
	    }
	}

	//printf( "[%s] [%s] [%c] [%d] [%d] [%s] \n", keyword, source, type, lang, line, struct_name);
	//printf( "[%s] [%s] [%s] [%d] \n", keyword, source, token, line);
	if( is_ignore_type(type, lang)){
	    eFree( keyword );
	    eFree( source );
	    if( struct_name != NULL ){
		eFree( struct_name );
		struct_name = NULL;
	    }
	    continue;
	}
	
	
	/*
	   Global  ׻ Global   ִ ݸ
	   Static  Global Static θ  Ƿ
	   Static    Global ƴѰ͵鸸 ϵ Ѵ.
	 */
	if( s == Static && !is_global ( keyword,  source, lang, type, line ) )
	    real_s = Static;
	else
	    real_s = Global;
	
	value = get_keyword_value( keyword, real_s );
	addKeyword( keyword, source, struct_name, lang, type, line, real_s, value); 

	if( s == Global )
	    add_tag_list(keyword, source, struct_name, lang, type,  line, value);

	struct_name = NULL;
    }
    if( s == Global )
	end_tag_list();
}


int main(int argc , char* argv[] )
{
    char *tmp_dir;
    char buf[BUF_MAX];
    setCurrentDirectory();

    preprocess_options(argv);
    check_dir_exist();
    
#if 0
    int i;
    printf( "	%s\n", html_dir);
    for( i=0; argv[i] != 0 ; i++ ){
	printf("%s\n", argv[i] ); 
    }
#endif

    init_pl_table();
    init_conf();
    //test_pl_table();

#if 1
    tmp_dir = eStrdup(CurrentDirectory);

    if(	chdir( html_dir ) < 0 )
	error( FATAL, "chdir to %s error\n",html_dir);
    setCurrentDirectory();

    init_option(argc, argv);

    //print_file_list();
#endif

#if 1
    /*
       global tag file global tag ִ ݸ
       static tag file  global  static ΰ ֱ 
       global  Էϰ, ⿡ ° static ϰ ȴ.
       ̰ init_keyword óѴ.
    */
    FILE *fd = fopen( GLOBAL_TAG_FILE, "r");
    init_keyword(fd, Global);
    fclose(fd);

    fd = fopen( TAG_FILE, "r");
    init_keyword(fd, Static );
    fclose(fd);
    //printKeywordTable();

#endif
#if 1
    
    if( !option.m )
	release_element_kinds();
    make_html();
    binary_dir_process();

    if(	chdir( tmp_dir ) < 0 )
	error( FATAL, "chdir to %s error\n",tmp_dir);
    setCurrentDirectory();
    eFree( tmp_dir );

    sprintf( buf, "mv  %s%s %s",  TMP_DIR, taglist_name, tmp_html_dir ); 
    if( system(buf ) < 0 )
	error( FATAL, "%s error\n", buf );
    sprintf( buf, "mv  %s %s",  tmp_html_dir, CurrentDirectory ); 
    if( system(buf ) < 0 )
	error( FATAL, "%s error\n", buf );

    copy_data();
#endif
#ifdef ALLOC_LIST
    showUnfreeMem();
#endif
    return 0;
}
