/**********************************************************************************
*   this file is part of c2h
*   Copyright (C)2005 Bruce Park ( jongsuknim@naver.com )
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation; either
*   version 2 of the License, or (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************************/
#include "general.h"
#include "keyword.h"
#include "routines.h"
#include "debug.h"
#include "pltable.h"
#include "filelist.h"
#include "makehtml.h"
#include "main.h"
#include "option.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <dirent.h>


struct Option option;
extern void print_help_msg(void)
{
    printf("-n\t print line number	\n\n");

    printf("-v\t vision\n");
    printf("\t HTML Ǵ  ǥ Ѵ.\n");

    printf("-m\t more link\n");
    printf("\t ũǴ  ø.   ʿ ,\n"); 
    printf("\t Ŭ     ũ   ʴ 쿡  ɼ ټ ִ.\n\n");
    /*
    printf("-b\t involve binary file\n");
    printf("\t Ǵ HTML 丮   Ѵ.\n\n"); 
    */

    /*
    printf("-c\t language cross referencing	\n");
    printf("\t   cross referencing Ѵ. \n\n");
    */

    printf("-I <directory list>\t Involve directory \n");
    printf("\t 丮 ϰ, ׵丮  ϵ鿡Ե Ѵ.\n");
    printf("\t  ɼ   丮  ̸  HTML丮 \n");
    printf("\t Ÿ ȴ.   \n");
    printf("\t ̿ɼ  丮 HTML 丮 Ÿ ȴ.\n\n");

    printf("-R <directory list>\t Recurcively involve directory\n");
    printf("\t -Iɼǰ  ̰  ؼ  Ѵ.\n\n");
    printf("\t -Iɼǰ ÿ ϼ   ɿ  ϼ Ƿ\n");
    printf("\t  ϸ ϴ 丮    ִ.\n\n");

    printf("-B <directory list>\t contaion binary directory\n");
    printf("\t  html丮  丮   빰 ° ϰ Ѵ.\n");
    printf("\t   丮 html  ʴ´.\n\n");

    printf("--auto=[yes|no]\t auto identify.	\n");
    printf("\t      ڵ Ǻ. Ʈ yes Ǿ ִ.\n"); 
    printf("\t  ɼ no    Ȯڰ       textó ν ϰ ȴ.\n"); 

    printf("--dir_index_name=<indexname>\n\n" );
    printf("\t  α׷   3  Ǵµ, dir_index.html , taglist.html , index.html  ȴ.\n");
    printf("\t ̶  ġ  ̿ɼ  dir_index.html ̸ ٲ  ִ.\n");

    printf("--index_name=<indexname>\n\n" );
    printf("\t ̿ɼ  index.html ̸ ٲ  ִ.\n");

    printf("--taglist_name=<indexname>\n\n" );
    printf("\t ̿ɼ  taglist.html ̸ ٲ  ִ.\n");
    
    printf("--target_dir=<target html directory name>\n\n" );
    printf("\t Ǵ 丮 ̸ HTMLε,  ġ   ɼ   ִ.\n");
    
    printf("--htmltype=[html|css|dhtml]\t \n");
    printf("\t Ǵ html  Ѵ. html  ȣȯ \n");    
    printf("\t html =  htmlθ ̷ ڵ带 Ѵ. Ȩ  Խǵ\n");
    printf("\t	     ִ.\n");
    printf("\t css  = css javascript ⺻ ɸ Ͽ ڵ带  \n");
    printf("\t	   css νϴ   ν  ڵ \n"); 
    printf("\t dhtml  = css javascript    Ͽ  κ  \n");
    printf("\t	   ie 6.0, firefox1.0̻  ν ϴ.\n\n"); 


}

static boolean make_tag(const char *target_files, const char *tag_name, scope s, boolean is_R, boolean is_dir)
{
    char tag_cmd[BUF_MAX];
    char R[4];
    char Scop[4];
    char Dir[4];

    if( target_files[0] == '\0' )
	return FALSE;

    if( is_R )
	sprintf( R, "-R");
    else
	sprintf( R, " ");

    if( s == Global )
	sprintf( Scop, "no");
    else
	sprintf( Scop, "yes");

    if( is_dir )
	sprintf( Dir, "*");
    else
	sprintf( Dir, " ");

    sprintf( tag_cmd, "ctags %s -f - --file-scope=%s --fields=+nl %s%s |\
	    tag_parsing.pl > %s"
	     , R, Scop, target_files, Dir, tag_name ); 
    //fprintf( stderr, "%s\n\n" , tag_cmd);
#if 0
    static int count = 0;
    char buf[BUF_MAX];
    sprintf( buf, "ctags %s -f - --file-scope=%s --fields=+nl %s%s > /tmp/test_tags%d", R, Scop, target_files, Dir, count++ );
    if( system( tag_cmd ) < 0)
	error ( FATAL,"system function error : %s %d" , __FILE__, __LINE__);
    printf("%s\n", buf );
#endif

    if( system( tag_cmd ) < 0)
	error ( FATAL,"system function error : %s %d" , __FILE__, __LINE__);
    return TRUE;
}

extern char *binary_dirs;

extern void init_option(int argc, char *argv[])
{
    int	    i,off;
    enum    option_status{ Normal, I, R , B }status = Normal;
    file_entry *tmp_file=NULL;
    int	    tag_num	=   0;
    char    tag_cmd[BUF_MAX];
    char    file_list[BUF_MAX];
    char    buf[BUF_MAX];
    char    tmp_binary_dirs[BUF_MAX];
    option.n	= FALSE;
    option.b	= FALSE;
    option.a	= TRUE;
    option.c	= FALSE;
    option.m	= FALSE;
    option.o	= FALSE;
    option.v	= FALSE;
    option.html_type = DhtmlType;

    file_list[0] = '\0';
    for(i = 1; i < argc; i++ )
    {
	/* option */
	off = 0;
	if( argv[i][off++] == '-' )
	{
opt_parsing:
	    switch( argv[i][off++] )
	    {
		case 'b':
		    option.b = TRUE;
		    goto opt_parsing;
		case 'v':
		    option.v = TRUE;
		    goto opt_parsing;
		case 'c':
		    option.c = TRUE;
		    goto opt_parsing;
		case 'n':
		    option.n = TRUE;
		    goto opt_parsing;
		case 'm':
		    option.m = TRUE;
		    goto opt_parsing;
		case 'o':
		    option.o = TRUE;
		    goto opt_parsing;
		case 'I':
		    status = I;
		    goto opt_parsing;
		case 'R':
		    status = R;
		    goto opt_parsing;
		case 'B':
		    status = B;
		    tmp_binary_dirs[0] = '\0';
		    goto opt_parsing;
		case 'N':
		    goto opt_parsing;
		case '-':
		    if( strncmp( &argv[i][2], "auto=", 5) == 0 ){
			if( struppercmp( &argv[i][7], "yes" ) == 0 ){
			    option.a = TRUE;
			    break;
			}
			else if( struppercmp( &argv[i][7], "no" ) == 0 ){
			    option.a = FALSE;
			    break;
			}
		    }
		    if( strncmp( &argv[i][2], "htmltype=", 9) == 0 ){
			if( struppercmp( &argv[i][11], "html" ) == 0 )
			    option.html_type = HtmlType;
			else if( struppercmp( &argv[i][11], "css" ) == 0 )
			    option.html_type = CssType;
			else if( struppercmp( &argv[i][11], "dhtml" ) == 0 )
			    option.html_type = DhtmlType;
		    }
			
		case '\0':
		    break;
		default:
		    error( FATAL, "unknown option %s %s %d\n", argv[i] , __FILE__, __LINE__ );
	    }
	}

	/* 
	   ⼭ ctag Ѽ  -I -R  丮 ׷ 
	     Ƽ ϳ tagϷ .
	   Normal  ϵ̳ ǹ̾ 丮, ̸ Ƶξٰ ߿
	   ctags Ű,
	   I R  ٷ ctags Ų. ̶    sort Ͽ
	   ϳ Ϸ  ؼ ü tag ȴ.
	   ̶ tag ϳ ̴ (c   static) Լ 
	   ʴ ϰ,
	   װͱ θ ϴ    Ѵ.
	    쿡 taglist.html ϴ° ̰ ȴ.
	    쿡 ؽ ̺ ϴµ ̰ ȴ.
	 */
	else
	{
	    if( !doesFileExist( argv[i]))
		error( FATAL, "unknown filename %s   %s %d\n", argv[i] , __FILE__ , __LINE__ );

	    
	    switch( status )
	    {
		case Normal:
		    tmp_file = create_file_entry( argv[i], FALSE , FALSE );
		    break;
		case I:
		    tmp_file = create_file_entry( argv[i], TRUE , FALSE );
		    break;
		case R:
		    tmp_file = create_file_entry( argv[i], FALSE , TRUE );
		    break;
		case B:
		    sprintf( tmp_binary_dirs,"%s %s", tmp_binary_dirs, argv[i] );
		    continue;
		default:
		    Assert(FALSE);
	    }
	    if( tmp_file == &binary_file )
		continue;
	    if( tmp_file->status->isDirectory )
	    {
		/*
		    -I or -R ɼ  ǹִ 丮 쿡 ٷ tag
		     
		 */
		if( tmp_file->is_I)
		{
		    sprintf( buf, "%stmp_tag%d", TMP_DIR, tag_num);
		    make_tag( argv[i], buf, Static,  FALSE, TRUE );
		    sprintf( buf, "%stmp_global_tag%d", TMP_DIR, tag_num);
		    if( make_tag( argv[i], buf, Global , FALSE, TRUE ))
			tag_num++;
		}
		else if( tmp_file->is_R)
		{
		    sprintf( buf, "%stmp_tag%d", TMP_DIR, tag_num);
		    make_tag( argv[i], buf, Static , TRUE , TRUE );
		    sprintf( buf, "%stmp_global_tag%d", TMP_DIR, tag_num );
		    if( make_tag( argv[i], buf, Global, TRUE , TRUE))
			tag_num++;
		}
	    }
	    else{
		strcat( file_list," ");
		strcat( file_list,argv[i]);
	    }
	   
	    insert_file_entry(tmp_file);

	}
    }

    /*
	Ƶξ normalϵ tag  
    */
    sprintf( buf, "%stmp_tag%d", TMP_DIR, tag_num );
    make_tag( file_list, buf, Static, FALSE , FALSE );
    sprintf( buf, "%stmp_global_tag%d", TMP_DIR, tag_num);
    if( make_tag( file_list, buf, Global, FALSE, FALSE ))
	tag_num++;

    file_list[0] = '\0';

    /*
	 tag  ϳ ħ
	ܺ ɾ sort Ͽ  ĥ ĵ · 
     */
    for(i=0; i < tag_num; i++ )
    {
	sprintf( buf,"%stmp_tag%d ",TMP_DIR,i);
	strcat( file_list," ");
	strcat( file_list,buf);
    }
    if( tag_num == 0 )
	return;
    //fprintf( stderr, "sort %s > %s\n", vStringValue(file_list), TAG_FILE);
    sprintf( tag_cmd, "sort -f %s > %s", file_list, TAG_FILE);
    //printf( "%s\n", tag_cmd);
    if( system( tag_cmd ) < 0)
	error ( FATAL,"system function error : %s %d" , __FILE__, __LINE__);

    file_list[0] = '\0';

    for(i=0; i < tag_num; i++ )
    {
	sprintf( buf,"%stmp_global_tag%d ",TMP_DIR,i);
	strcat( file_list," ");
	strcat( file_list,buf);
    }
    //fprintf( stderr, "sort %s > %s\n", vStringValue(file_list), GLOBAL_TAG_FILE	);
    sprintf( tag_cmd, "sort -f %s > %s", file_list, GLOBAL_TAG_FILE );
    //printf( "%s\n", tag_cmd);
    if( system( tag_cmd ) < 0)
	error ( FATAL,"system function error : %s %d" , __FILE__, __LINE__);

    /*
        ӽ tmp_tag 
    */
#if 1
    for(i=0; i < tag_num; i++ )
    {
	sprintf( buf, "%stmp_tag%d", TMP_DIR, i);
	if( unlink( buf) < 0 )
	    error( WARNING,"waring: unlinking error of tmp_global_tag%d\n", i );

	sprintf( buf, "%stmp_global_tag%d", TMP_DIR, i);
	if( unlink( buf) < 0 )
	    error( WARNING,"waring: unlinking error of tmp_global_tag%d\n", i );
    }

#endif

    if( tmp_binary_dirs[0] != '\0')
	binary_dirs = eStrdup( tmp_binary_dirs );
    else
	binary_dirs = NULL;

    return;

}



