/**********************************************************************************
*   this file is part of c2h
*   Copyright (C)2005 Bruce Park ( jongsuknim@naver.com )
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation; either
*   version 2 of the License, or (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************************/
#include "general.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "routines.h"
#include "debug.h"
#include "main.h"

#include "pltable.h"

#include "syntax/aml.h"
#include "syntax/asm.h"
#include "syntax/awk.h"
#include "syntax/c.h"
#include "syntax/cobol.h"
#include "syntax/csharp.h"
#include "syntax/eiffel.h"
#include "syntax/fortran.h"
#include "syntax/make.h"
#include "syntax/html.h"
#include "syntax/java.h"
#include "syntax/jscript.h"
#include "syntax/lisp.h"
#include "syntax/lua.h"
#include "syntax/pascal.h"
#include "syntax/perl.h"
#include "syntax/php.h"
#include "syntax/python.h"
#include "syntax/rexx.h"
#include "syntax/ruby.h"
#include "syntax/scheme.h"
#include "syntax/tcl_tk.h"
#include "syntax/shell.h"
#include "syntax/verilog.h"

#include "exception_rules.h"

#define default_set( target, attr ) if( (target) == NULL ) (target) = (attr)
int font_type_num = 8;

const char *LANG_LIST[] = { PL_LIST_STRING };

const int pl_num = sizeof(LANG_LIST) / sizeof(char**);
PL pl_table[sizeof(LANG_LIST) / sizeof(char**)];

configure conf;
lang_type get_lang_type_with_content( const char *fname)
{
    FILE *fd;
    char buf[BUF_MAX];
    char token[BUF_MAX];
    int i,j;
    fileStatus *stat;
    
    if( strcmp( get_base_file(fname), "Makefile") == 0 )
	return Make;

    stat = eStat( fname);
    Assert(stat->exists);
#if 0
    if( !stat->isExecutable )
	return Ignore;
#endif
    eStatFree(stat);

    fd = fopen( fname ,"r");
    if( fd == NULL )
	error( FATAL, "file open error %s  %s %d\n", fname , __FILE__, __LINE__ );
    do{ 
	fgets( buf, BUF_MAX, fd );
    }while(buf[0] == '\n' );
    fclose( fd );

    /*
	#! /usr/perl  perl ̾Ƴ 
     */
    if( buf[0] != '#' || buf[1] != '!' )
	return Ignore;
    

    i = 2;
    while( isspace(buf[i]))
	i++;
    j=0;
    while( !isspace(buf[i])){
	if( buf[i] == '/' )
	    j=0;
	else
	    token[j++] = buf[i];
	i++;
    }
    token[j] = '\0';

    /* #! /xxx/yyy/env python */
    if( strcmp( token , "env" ) == 0){ 
	while( isspace(buf[i]))
	    i++;

	j=0;
	while( isalnum(buf[i]))
	    token[j++] = buf[i++];
	token[j] = '\0';
    }


    for( i=0; i< pl_num; i++ )
	if( struppercmp(token, LANG_LIST[i] ) == 0){
	    //fprintf( stderr,"%s  %s %d \n",buf,token,i);
	    return i;
	}

    if( strcmp( token, "sh" ) == 0 || strcmp( token, "bash" ) == 0 ||
	strcmp( token, "ksh" ) == 0 || strcmp( token, "csh" ) == 0 )
	return Shell;

    return Ignore;
}


boolean is_ignore_list( lang_type lang)
{
    return FALSE;
}

lang_type get_lang_type_with_extension( const char *extension )
{
    int i,k; 
    for( i =0 ; i < pl_num; i++ )
    {
	for(k=0; pl_table[i].file_extensions[k] ; k++ )
	{
	    if( struppercmp( extension, pl_table[i].file_extensions[k] ) == 0 )
		return i;
	}
    }
    return Ignore;
}

lang_type get_lang_type( const char *lang_name )
{
    int i;
    char buf[16];
    if( strcmp( lang_name , "C++") == 0 ){
	sprintf( buf, "C");
	lang_name = buf;
    }
    for( i=0 ; i < pl_num; i++ )
    {
	if( strcmp( lang_name, LANG_LIST[i] ) == 0 )
	    return i;
    }
    return Ignore;
}
static int delete_white( const char *buf, int *i)
{
    for( ; *i < BUF_MAX ; *i += 1 ){
	if( buf[*i] == ' ' || buf[*i] == '\t' )
	    continue;
	else
	    break;
    }
    if (*i == BUF_MAX )
	return -1;
    return buf[*i];
}

static char *get_content( const char *str, FILE *f)
{
    char buf[BUF_MAX]; 
    char *retval;
    int i,len;

    while( fgets( buf , BUF_MAX , f ) != NULL )
    {
	i = 0;
	if( delete_white( buf, &i) < 0 )
	    continue;

	len = strlen(str);
	if(strnuppercmp( &buf[i] , str , len ) != 0 )
	    continue;
	
	i += len;

	if( delete_white( buf, &i ) != (int)'=' )
	    continue;
	if( delete_white( buf, &i ) < 0 )
	    continue;

	retval = eStrdup( &buf[i] );
	len = strlen( retval);
	for( ; isspace((int)retval[len]); len-- );
	retval[len] = '\0';
    }
    return NULL;
}

void init_conf(void)
{
    char buf[BUF_MAX];
    FILE *f;

    sprintf( buf, "%s/.code2htmlrc", getenv("HOME"));
    memset( &conf , 0x00, sizeof(conf));
    if( doesFileExist(buf) )
    {
	f = fopen( buf, "r");
	if( f == NULL )
	    error( FATAL, "file open error   %s %d\n", __FILE__ , __LINE__ );

	conf.bg_color	    = get_content("bg_color",f); 
	conf.index_bg_color = get_content("index_bg_color",f); 
	conf.tag_bg_color   = get_content("tag_bg_color",f); 

	conf.font_color	    = get_content("font_color",f); 
	conf.index_font_color=get_content("index_font_color",f); 
	conf.tag_font_color = get_content("tag_font_color",f); 
	conf.keyword_color  = get_content("keyword_color",f); 
	conf.keyword1_color  = get_content("keyword1_color",f); 
	conf.keyword2_color  = get_content("keyword2_color",f); 
	conf.cmt_color	    = get_content("cmt_color",f); 
	conf.string_color   = get_content("string_color",f); 
	
	conf.font_size	    = get_content("font_size",f); 
	conf.index_font_size= get_content("index_font_size",f); 
	conf.tag_font_size  = get_content("tag_font_size",f); 
	conf.keyword_size   = get_content("keyword_size",f); 
	conf.keyword1_size   = get_content("keyword1_size",f); 
	conf.keyword2_size   = get_content("keyword2_size",f); 
	conf.cmt_size	    = get_content("cmt_size",f); 
	conf.string_size    = get_content("string_size",f); 

	conf.font_style	    = get_content("font_style",f); 
	conf.index_font_style=get_content("index_font_style",f); 
	conf.tag_font_style = get_content("tag_font_style",f); 
	conf.keyword_style  = get_content("keyword_style",f); 
	conf.keyword1_style  = get_content("keyword1_style",f); 
	conf.keyword2_style  = get_content("keyword2_style",f); 
	conf.cmt_style	    = get_content("cmt_style",f); 
	conf.string_style   = get_content("string_style",f); 
	conf.frameset	    = get_content("frameset",f);
	fclose( f );

    }

    default_set(conf.bg_color       , "whitesmoke");
    default_set(conf.index_bg_color , "whitesmoke");
    default_set(conf.tag_bg_color   , "whitesmoke");

    default_set(conf.font_color	    , "black");
    default_set(conf.index_font_color, "black");
    default_set(conf.tag_font_color , "black");
    default_set(conf.keyword_color  , "olive");
    default_set(conf.keyword1_color  , "yellow");
    default_set(conf.keyword2_color  , "green");
    default_set(conf.cmt_color	    , "purple");
    default_set(conf.string_color   , "crimson");
    
    default_set(conf.frameset	    , eStrdup("dir, taglist, source"));

    /*
       TODO
	Ʒ κ  ʿ, ū   Ƽ dir, source, taglist ̿ܿ
	ٸ ̸ ִ°  Ѿ Ѵ. 
	׸ Կ ־ ҹڴ ϵ Ѵ.
	 ݵ  
     */
    if( strstr( conf.frameset, "dir") != NULL )
	conf.is_dir_exist = TRUE;
    else
	conf.is_dir_exist = FALSE;

    if( strstr( conf.frameset, "source") != NULL )
	conf.is_source_exist = TRUE;
    else
	conf.is_source_exist = FALSE;

    if( strstr( conf.frameset, "taglist") != NULL )
	conf.is_taglist_exist = TRUE;
    else
	conf.is_taglist_exist = FALSE;
}

void init_pl_table(void) 
{
#include "generation/init_pl_table.h"
}

void test_pl_table(void)
{
    int i,k=0;
    for( i=0; i< pl_num ; i++ )
    {
       printf("\n========%s=========\n", LANG_LIST[i]);
       printf("line_cmt: %s\n", pl_table[i].line_cmt );
       printf("delimiters: %s\n", pl_table[i].delimiters);
       printf("string_chars: %s\n", pl_table[i].string_chars);
       printf("escape_char: %s\n", pl_table[i].escape_char);
       k=0;
       while( pl_table[i].keyword_block_on[k] )
       printf("keyword_block_on: %s\n", pl_table[i].keyword_block_on[k++]);
       k=0;
       while( pl_table[i].keyword_block_off[k] )
       printf("keyword_block_off: %s\n", pl_table[i].keyword_block_off[k++]);
       k=0;
       while( pl_table[i].block_cmt_on[k] )
	   printf("block_cmt_on: %s\n", pl_table[i].block_cmt_on[k++]);
       k=0;
       while( pl_table[i].block_cmt_off[k] )
	   printf("block_cmt_off: %s\n", pl_table[i].block_cmt_off[k++]);
       k=0;
       while( pl_table[i].file_extensions[k] )
	   printf("file_extensions: %s\n", pl_table[i].file_extensions[k++]);
       k=0;
       printf("keyword: ");
       while( pl_table[i].keywords[k] )
	   printf("[%s] ", pl_table[i].keywords[k++] );
       printf("\n");
       k=0;
       printf("keyword1: ");
       while( pl_table[i].keywords1[k] )
	   printf("{%s} ", pl_table[i].keywords1[k++] );
       printf("\n");

    }

}

extern const char *get_type_name ( lang_type l, char type )
{
    int i; 
    if( l == Ignore )
	return "";
    for( i = 0 ; pl_table[l].type[i] != '\0'; i++ )
	if( pl_table[l].type[i] == type )
	    return pl_table[l].type_name[i];
    return "";
}

extern void release_element_kinds(void)
{
    int i;
    for( i=0; i< pl_num ; i++ )
    {
//	pl_table[i].type = NULL;
//	pl_table[i].type_name = NULL;

	pl_table[i].element_type = NULL;
	pl_table[i].struct_type = NULL;
	pl_table[i].element_divide_string = NULL;	
    }
}

