/**********************************************************************************
*   this file is part of c2h
*   Copyright (C)2005 Bruce Park ( jongsuknim@naver.com )
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation; either
*   version 2 of the License, or (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************************/
#include "general.h"
#include "routines.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "makehtml.h"
#include "filelist.h"
#include "option.h"
#include "debug.h"
#include "taglist.h"

#include "htmlprocess.h"

static FILE *tag_list;

extern void init_tag_list(const char *f_name)
{
    tag_list = fopen( f_name , "w");
    if (tag_list == NULL )
	error( FATAL,"open file error %s  %s %d\n",
		f_name, __FILE__, __LINE__);
    switch( option.html_type ){
	case HtmlType:
	    fputs( "<html><head><title>taglist</title></head>\n", tag_list );
	    fprintf( tag_list, "<body bgcolor=\"%s\">\n", conf.tag_bg_color);
	    break;
	case CssType:
	    fputs( "<html><head><title>taglist</title>\n", tag_list );
	    fputs( "<link rel=\"stylesheet\" type=\"text/css\" href=\"c2h.css\">", tag_list );
	    fputs( "</head><body>\n" , tag_list);
	    fputs( "<script type=\"text/javascript\" src=\"c2h.js\"></script>" , tag_list);
	    break;
	case DhtmlType:
	    fputs("<head>\n", tag_list);
	    fputs("<link rel=\"stylesheet\" type=\"text/css\" href=\"tooltip.css\">\n", tag_list );
	    fputs("<link rel=\"stylesheet\" type=\"text/css\" href=\"c2h.css\">\n", tag_list );
	    fputs("</head><body>\n", tag_list);
	    fputs("<script type=\"text/javascript\" src=\"tooltip.js\"></script>", tag_list );
	    fputs("<script type=\"text/javascript\" src=\"layerHandler.js\"></script>", tag_list );
	    break;
    }
    font_begin(Tag, conf.tag_font_size, conf.tag_font_color, conf.tag_font_style, tag_list );
}

typedef struct KeyData{
    char *keyword;
    int value;
    struct KeyData *next;
}keydata;

keydata *keydata_head=NULL;
static keydata *get_keydata(const char *const keyword)
{
    keydata *tmp;
    for( tmp = keydata_head ; tmp != NULL ; tmp = tmp->next )
	if( strcmp( keyword, tmp->keyword ) == 0 )
	    return tmp;
    return NULL;
}


static void add_keydata( const char *const keyword , int value )
{
    keydata *data;
    data = get_keydata( keyword );
    if( data == NULL ){
	data  = xMalloc( 1, keydata );
	data->keyword = eStrdup( keyword );
	data->value = value;

	data->next = keydata_head;
	keydata_head = data;
    }else{
	//Assert( value > data->value );
	data->value = value;
    }
}

static void recursive_delete( keydata *data)
{
    if( data == NULL )
	return;
    else
	recursive_delete( data->next );
    eFree( data->keyword );
    eFree( data );
}

static void destroy_keydata( void )
{
    recursive_delete( keydata_head );
    keydata_head = NULL;
}

extern int get_keyword_value( const char *const keyword, scope s)
{
    static const char *preceed = NULL; 
    static int value;
    keydata *data;

    if( preceed != NULL && strcmp( preceed , keyword ) == 0 )
	value++;
    else if( preceed != NULL && struppercmp( preceed, keyword ) == 0 )
    {
	data = get_keydata( keyword );
	add_keydata( preceed, value );
	if( data == NULL ){
	    value = 0;
	}else
	    value = ++data->value;
    }
    else 
    {
	destroy_keydata();
	value = 0;
    }
    preceed = keyword;
    if( s == Static )
	return value + 1000000;
    else
	return value;
}

extern char * get_dir_expend_id( const char *source )
{
    char *tmp, *tmp2;
    char buf[BUF_MAX];
    tmp =  (char*)source ;

    while( *tmp == '.' || *tmp == '/' )
	tmp++;

    tmp2 = get_dir_name( tmp );
    sprintf( buf,"%s",html_name );
    strcat( buf, tmp2 );
    eFree(tmp2);

    return eStrdup( buf);
}

extern void add_tag_list(const char *const keyword, const char *const source, const char *const struct_name,
			lang_type language, char type, int line,  int value)
{
    char buf[BUF_MAX];
    char opt_buf[BUF_MAX];
    char *tmp, *ptr;

    buf[0] = '\0';
    opt_buf[0] = '\0';
    switch( option.html_type ){
	case HtmlType:
	    if( conf.is_source_exist )
		strcat( opt_buf,"target=\"source\" ");
	    break;
	case CssType:
	    if( conf.is_source_exist )
		strcat( opt_buf,"target=\"source\" ");
	    if( conf.is_dir_exist ){
		tmp = get_dir_name(source);
		sprintf( buf," onClick=\"top.dir.location.href = \'%sdir_index.html#%s\'\" ", 
			    tmp, baseFilename( source ) );
		eFree(tmp);
		strcat( opt_buf, buf );
	    }
	    break;
	case DhtmlType:
	    if( conf.is_source_exist )
		strcat( opt_buf,"target=\"source\" ");
	    if( conf.is_dir_exist ){

		tmp = get_dir_expend_id( source );
		sprintf( buf," onClick=\"javascript:top.dir.expandFolder('%s')\"", 
			   tmp );
		eFree(tmp);
		strcat( opt_buf, buf );
	    }

	    tmp = relativeFilename( source, "./" );
	    ptr = (char*)get_base_file( tmp );
	    if( ptr != tmp ){
		*(ptr - 1) = '\0';
		sprintf( buf, " onMouseover=\"ddrivetip(\'%s/<br>%s<br><i><font color=red>\
		    %s %s</i></font>\')\"; onMouseout=\"hideddrivetip()\"",
			tmp, ptr, (struct_name == NULL) ? "":struct_name, get_type_name(language, type )); 
	    }else{
		sprintf( buf, " onMouseover=\"ddrivetip(\'%s<br><i><font color=red>\
		    %s %s</i></font>\')\"; onMouseout=\"hideddrivetip()\"",
			tmp, (struct_name == NULL) ? "":struct_name , get_type_name(language, type )); 
	    }
	    //fprintf( stderr,"%s %s %s \n", content->source, f->relative_dir, tmp );
	    eFree(tmp);
	    strcat( opt_buf, buf );
	    break;
    }

    fprintf(tag_list,"<a name=\"%s%d\" href=\"%s.html#%s%d\" %s>%s</a><br>\n",
	    keyword, value , source, keyword, value , opt_buf, keyword);
}

extern void end_tag_list()
{
    font_end(tag_list);
    fputs("</body>\n</html>\n",tag_list);
    fclose(tag_list);
}

