# -*- coding: utf-8 -*-
import gtk
import pango
import WIDGET

GLADEFILE = "vi-python.glade"

class FontSelectionDialog (WIDGET.WIDGET) :

	def __init__ (self, ROOT, TAB) :
		handler = { \
			"on_ok"	: self.on_ok,
			"on_cancel" : self.on_close,
			"on_apply" : self.on_apply,
		}

		WIDGET.WIDGET.__init__( \
			self, GLADEFILE, "fontselectiondialog1", ROOT, handler)

		self.TAB = TAB
		self.WIDGET_SELF.set_font_name(self.TAB.VTE.VTE.get_font().to_string())

	def on_apply (self, widget) :
		self.setFont()

	def on_ok (self, widget) :
		self.setFont()
		self.on_close(widget)

	def setFont (self) :
		pd = pango.FontDescription(self.WIDGET_SELF.get_font_name())
		self.TAB.VTE.VTE.set_font(pd)

class FileSelectionDialog (WIDGET.WIDGET) :

	def __init__ (self, ROOT) :

		self.ROOT = ROOT

		handler = { \
			"on_open"	: self.on_open, \
			"on_cancel" : self.on_close, \
		}

		WIDGET.WIDGET.__init__( \
			self, GLADEFILE, "filechooserdialog2", None, handler)

		self.FileChooser = \
			self.WIDGET_SELF.get_children()[0].get_children()[0].get_children()[0]

	def on_open (self, widget) :

		file_selected = list()
		if self.FileChooser.get_select_multiple() :
			file_selected = self.FileChooser.get_filenames()
		else :
			file_selected.append(self.FileChooser.get_filename())

		__b = self.xml.get_widget("checkbutton1")
		openInThisPage = __b.get_active()

		for i in file_selected :
			self.ROOT.addVim(i, openInThisPage)

		self.WIDGET_SELF.destroy()

class About (WIDGET.WIDGET) :

	def __init__ (self) :
		WIDGET.WIDGET.__init__(self, GLADEFILE, "about")

	def on_ok (self, widget) :
		self.on_close(widget)

import GConf, Conf
class Preference (WIDGET.WIDGET) :

	GCONF_CLIENT = None

	FONT_DEFAULT_SYSTEM = str()

	def __init__ (self, gconf_client) :

		if not isinstance(gconf_client, GConf.Client) :
			raise ValueError, "gconf_client must be the instance of Gconf.Client."
		else :
			self.GCONF_CLIENT = gconf_client

		handler = { \
			"on_use_system_font" : self.on_use_system_font, \
			"on_font_set_vim" : self.on_font_set_vim, \
			"on_font_set_console" : self.on_font_set_console, \
			"on_toggle_menubar" : self.on_toggle_menubar, \
			"on_toggle_toolbar" : self.on_toggle_toolbar, \
			"on_change_vim" : self.on_change_vim, \
			"on_change_console" : self.on_change_console, \
			"on_color_set_fore" : self.on_color_set_fore, \
			"on_color_set_back" : self.on_color_set_back, \
		}

		WIDGET.WIDGET.__init__(self, GLADEFILE, "dialog1", None, handler)

		# set default system font.
		self.FONT_DEFAULT_SYSTEM = self.GCONF_CLIENT.get_value( \
				Conf.GLOBAL_FONT_SYSTEM_DEFAULT)

		# set font name
		__fontname_vim = self.GCONF_CLIENT.get_value(Conf.LOCAL_FONT_VIM)
		__fontname_console = \
			self.GCONF_CLIENT.get_value(Conf.LOCAL_FONT_CONSOLE)

		__widget_font_vim = self.xml.get_widget("fontbutton3")
		__widget_font_console = self.xml.get_widget("fontbutton4")
		__widget_font_system_default = self.xml.get_widget("checkbutton12")
		if __fontname_vim :
			__widget_font_vim.set_font_name(__fontname_vim)

		if __fontname_console :
			__widget_font_console.set_font_name(__fontname_console)

		__use_system_default_font = self.GCONF_CLIENT.get_value( \
			Conf.LOCAL_FONT_USE_SYSTEM_DEFAULT)

		if __use_system_default_font :
			__widget_font_vim.set_sensitive(False)
			__widget_font_console.set_sensitive(False)
			__widget_font_system_default.set_active(True)
		else :
			__widget_font_system_default.set_active(False)

		__checkbutton_hide_menubar = self.xml.get_widget("checkbutton13")
		__checkbutton_hide_toolbar = self.xml.get_widget("checkbutton14")

		# show/hide menubar, toolbar
		__show_menubar = self.GCONF_CLIENT.get_value(Conf.LOCAL_SHOW_MENUBAR)
		self.xml.get_widget("checkbutton13").set_active(__show_menubar)

		__show_toolbar = self.GCONF_CLIENT.get_value(Conf.LOCAL_SHOW_TOOLBAR)
		self.xml.get_widget("checkbutton14").set_active(__show_toolbar)

		__widget_command_vi = self.xml.get_widget("entry13")
		__widget_command_console = self.xml.get_widget("entry14")

		__command_vi = self.GCONF_CLIENT.get_value( \
			Conf.LOCAL_COMMAND_VI)
		__command_console = self.GCONF_CLIENT.get_value( \
			Conf.LOCAL_COMMAND_CONSOLE)

		__widget_command_vi.set_text(__command_vi)
		__widget_command_console.set_text(__command_console)

		# color
		__widget_color_fore = self.xml.get_widget("colorbutton21")
		__widget_color_back = self.xml.get_widget("colorbutton22")

		__color_fore = \
			self.GCONF_CLIENT.get_list("int", Conf.LOCAL_COLOR_FOREGROUND)
		__color_back = \
			self.GCONF_CLIENT.get_list("int", Conf.LOCAL_COLOR_BACKGROUND)

		__widget_color_fore.set_color(gtk.gdk.Color( \
			__color_fore[0], \
			__color_fore[1], \
			__color_fore[2], \
			) \
		)

		__widget_color_back.set_color(gtk.gdk.Color( \
			__color_back[0], \
			__color_back[1], \
			__color_back[2], \
			) \
		)

	def on_color_set_fore (self, widget) :
		__color = widget.get_color()

		self.GCONF_CLIENT.set_list( \
			"int", \
			Conf.LOCAL_COLOR_FOREGROUND, \
			[__color.red, __color.green, __color.blue, __color.pixel])

	def on_color_set_back (self, widget) :
		__color = widget.get_color()

		self.GCONF_CLIENT.set_list( \
			"int", \
			Conf.LOCAL_COLOR_BACKGROUND, \
			[__color.red, __color.green, __color.blue, __color.pixel])

	def on_change_console (self, widget) :
		self.GCONF_CLIENT.set_value("string", \
			Conf.LOCAL_COMMAND_CONSOLE, \
			widget.get_text())

	def on_change_vim (self, widget) :
		self.GCONF_CLIENT.set_value("string", \
			Conf.LOCAL_COMMAND_VI, \
			widget.get_text())

	def on_toggle_menubar (self, widget) :
		__is_activated = widget.get_active()
		self.GCONF_CLIENT.set_value("bool", \
			Conf.LOCAL_SHOW_MENUBAR, __is_activated)

	def on_toggle_toolbar (self, widget) :
		__is_activated = widget.get_active()
		self.GCONF_CLIENT.set_value("bool", \
			Conf.LOCAL_SHOW_TOOLBAR, __is_activated)

	def on_font_set_vim (self, widget) :
		__font_name = widget.get_font_name()

		self.GCONF_CLIENT.set_value("string", \
			Conf.LOCAL_FONT_VIM, __font_name)

	def on_font_set_console (self, widget) :
		__font_name = widget.get_font_name()

		self.GCONF_CLIENT.set_value("string", \
			Conf.LOCAL_FONT_CONSOLE, __font_name)

	def on_use_system_font (self, widget) :

		__checkbutton = self.xml.get_widget("checkbutton12")

		__buttonFontVIM = self.xml.get_widget("fontbutton3")
		__buttonFontConsole = self.xml.get_widget("fontbutton4")

		__labelFontVIM = self.xml.get_widget("label75")
		__labelFontConsole = self.xml.get_widget("label76")

		if __checkbutton.get_active() :

			__buttonFontConsole.set_sensitive(False)
			__buttonFontVIM.set_sensitive(False)

			__labelFontConsole.set_sensitive(False)
			__labelFontVIM.set_sensitive(False)

			self.GCONF_CLIENT.set_value("bool", \
				Conf.LOCAL_FONT_USE_SYSTEM_DEFAULT, True)
		else :
			self.GCONF_CLIENT.set_value("bool", \
				Conf.LOCAL_FONT_USE_SYSTEM_DEFAULT, False)

			__buttonFontConsole.set_sensitive(True)
			__buttonFontVIM.set_sensitive(True)

			__labelFontConsole.set_sensitive(True)
			__labelFontVIM.set_sensitive(True)

"""
Description
-----------


ChangeLog
---------


Usage
-----


"""

__author__ =  "Spike^ekipS <spikeekips@gmail.com>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "Dialog.py"

