# -*- coding: utf-8 -*-

import pygtk
pygtk.require("2.0")

import gtk
import gtk.gdk
import gtk.glade

import os

class Label (gtk.HBox) :

	LABELNAME = "None"
	STATE = None
	VTE = None

	WITHOUT_CLOSEBUTTON = False

	def __init__ (self, **kwargs) :

		gtk.HBox.__init__(self, False, 2)

		if kwargs.has_key("state") :
			self.STATE = kwargs["state"]

		if kwargs.has_key("without_closebutton") :
			if kwargs["without_closebutton"] :
				self.WITHOUT_CLOSEBUTTON = True

		self.make()
		self.show()

	def make (self) : pass

	def registerVTE (self, vte) :
		self.VTE = vte

class TabWithClose (Label) :

	def __init__ (self, **kwargs) :

		if kwargs.has_key("filename") :
			self.LABELNAME = kwargs["filename"]

		Label.__init__(self, **kwargs)

	def make (self, labelname=None) :
		if not labelname : labelname = self.LABELNAME

		# make label.
		self.Label = gtk.Label(labelname)
		self.Label.set_selectable(False)
		self.Label.set_justify(gtk.JUSTIFY_CENTER)
		self.Label.show()

		EventBox1 = gtk.EventBox()
		EventBox1.add(self.Label)
		EventBox1.show()

		# make close button
		if not self.WITHOUT_CLOSEBUTTON :
			self.Button = gtk.Image()
			self.Button.set_from_stock( \
				gtk.STOCK_CLOSE, gtk.ICON_SIZE_DND)
			self.Button.show()

			EventBox0 = gtk.EventBox()
			EventBox0.add(self.Button)
			EventBox0.show()

			EventBox0.connect("event", self.on_tab_close)

		# connect event with method.
		EventBox1.connect("event", self.on_tab_label)

		# add close button and label in HBOX
		#self.add(EventBox1)
		self.pack_start(EventBox1, False)

		if not self.WITHOUT_CLOSEBUTTON :
			self.pack_end(EventBox0, False)

	def on_tab_label (self, parm1, parm2) :
		__type = parm2.type

		if __type is gtk.gdk.ENTER_NOTIFY :
			if self.LABELNAME == "None" : return

			self.STATE.DATA["statusbar"].set_label( \
				" %s" % self.LABELNAME)
		elif __type is gtk.gdk.LEAVE_NOTIFY :
			self.STATE.DATA["statusbar"].set_label("")
		else :
			pass

	def on_tab_close (self, parm1, parm2) :
		__type = parm2.type

		if __type is gtk.gdk.ENTER_NOTIFY :
			if self.LABELNAME == "None" : return

			self.STATE.DATA["statusbar"].set_label( \
				" %s" % self.LABELNAME)
		elif __type is gtk.gdk.LEAVE_NOTIFY :
			self.STATE.DATA["statusbar"].set_label("")
		elif __type is gtk.gdk.BUTTON_PRESS :
			self.VTE.exit()
			self.STATE.DATA["statusbar"].clean()
		else :
			pass

	def get_label (self) :
		return self.LABELNAME

	def set_label (self, label_name) :
		self.LABELNAME = label_name
		self.Label.set_label(label_name)

class TabWithCloseForVim (TabWithClose) :
	LABELNAME = None
	LABELNAME_SHORT = None

	def __init__ (self, **kwargs) :

		if kwargs.has_key("filename") :
			self.LABELNAME = kwargs["filename"]

		if self.LABELNAME.strip() :
			self.LABELNAME_SHORT = os.path.basename(self.LABELNAME)

		gtk.HBox.__init__(self, False, 2)

		if kwargs.has_key("state") :
			self.STATE = kwargs["state"]

		self.make(self.LABELNAME_SHORT)
		self.show()

	def set_label (self, text) :
		self.LABELNAME = text
		self.LABELNAME_SHORT = os.path.basename(text)

	def get_label (self) :
		return self.LABELNAME

class Statusbar :

	CONTEXT = None
	CONTEXT_ID = None
	MESSAGE_ID = None

	INSTANCE_STATUSBAR = None

	TMP_TEXT = str()

	def __init__ (self, instanceOfStatusbar, context="default") :

		if not isinstance(instanceOfStatusbar, gtk.Statusbar) :
			raise ValueError, "instanceOfStatusbar must be gtk.Statusbar"
		else :
			self.INSTANCE_STATUSBAR = instanceOfStatusbar

		self.CONTEXT_ID = self.INSTANCE_STATUSBAR.get_context_id(context)

	def clean (self) :
		self.set_label("")

	def set_label (self, text) :

		# remove previous message.
		try :
			self.INSTANCE_STATUSBAR.remove(self.CONTEXT_ID, self.MESSAGE_ID)
		except :
			pass

		self.MESSAGE_ID = self.INSTANCE_STATUSBAR.push(self.CONTEXT_ID, text)

"""
Description
-----------


ChangeLog
---------


Usage
-----


"""

__author__ =  "Spike^ekipS <spikeekips@gmail.com>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "Label.py"


