#!/usr/bin/env python
# -*- coding: utf-8 -*-
import sys, os, shutil, sha, time

import pygtk
pygtk.require("2.0")

try :
	import gtk
	import gtk.glade
	import gobject
	import pango
	import gconf
except :
	print "you need to install python-gnome2 and pygtk and GTKv2."
	sys.exit(1)

import TAB, WIDGET, Label, State, Dialog, GConf, Conf

class main (WIDGET.WIDGET) :

	LIST_TAB = list()
	NOTEBOOK = None

	STATE = None
	IS_LOGO = True

	Toolbar = None
	Menubar = None

	def __init__ (self) :

		handler = { \
			# etc.
			"on_font_select" : self.on_fontSelectionDialog, \
			"on_insert_vim" : self.on_insert_vim, \
			"on_remove_page" : self.on_remove_page, \
			"on_open_file_dialog" : self.on_fileSelectionDialog, \
			"on_font_increase" : self.on_font_increase, \
			"on_font_decrease" : self.on_font_decrease, \
			"on_insert_console" : self.on_insert_console, \
			"on_about" : self.on_about, \
			"on_preference" : self.on_preference, \
			"on_next_tab" : self.on_next_tab, \
			"on_previous_tab" : self.on_previous_tab, \
			"on_show_toolbar" : self.on_show_toolbar, \
			"on_show_menubar" : self.on_show_menubar, \
			"on_toggled_show_toolbar" : self.on_toggled_show_toolbar, \
			"on_toggled_show_menubar" : self.on_toggled_show_menubar, \
		}

		WIDGET.WIDGET.__init__(self, GLADEFILE, "vi-python", None, handler)

		# create accelerator group.
		self.AccelGrp = gtk.AccelGroup()

		self.STATE = State.State()

		# preference
		self.GCONF_CLIENT = GConf.Client()
		self.GCONF_CLIENT.add_dir(Conf.LOCAL_ROOT)

		gconf_notify = GConf.Notify(self.GCONF_CLIENT, state=self.STATE)
		gconf_notify.notify()

		self.GCONF_CLIENT.set_path(Conf.LOCAL_ROOT)

		self.NOTEBOOK = self.xml.get_widget("notebook1")
		self.NOTEBOOK.remove_page(0)

		# store information into state
		self.STATE.set_value("root-widget", self.WIDGET_SELF)
		self.STATE.set_value("notebook", self.NOTEBOOK)
		self.STATE.set_value("tab-list", self.LIST_TAB)

		# status bar.
		STATUSBAR = Label.Statusbar(self.xml.get_widget("statusbar1"))
		self.STATE.set_value("statusbar", STATUSBAR)

		# default tab is VIM.
		self.addLogo()

		# set event.
		EB = self.xml.get_widget("eventbox1")
		EB.connect("event", self.on_set_background_logo)

		# toolbar and menubar
		self.Toolbar = self.xml.get_widget("toolbar1")
		if not self.GCONF_CLIENT.get_value(Conf.SCHEMA["show-toolbar"]["key"]) :
			self.Toolbar.hide()

		self.Menubar = self.xml.get_widget("hbox1")
		self.Menubar.connect("hide", self.activate_accelerator)
		if not self.GCONF_CLIENT.get_value(Conf.SCHEMA["show-menubar"]["key"]) :
			self.Menubar.hide()

		self.STATE.set_value("toolbar", self.Toolbar)
		self.STATE.set_value("menubar", self.Menubar)

		self.WIDGET_SELF.add_accel_group(self.AccelGrp)

		print "==========================================="
		print "All Launched."
		print ""

	def on_toggled_show_menubar (self, widget) :
		if widget.get_active() :
			self.Menubar.hide()
			widget.set_label("메뉴바 보이기")
		else :
			self.Menubar.show()
			widget.set_label("메뉴바 감추기")

	def on_toggled_show_toolbar (self, widget) :
		if widget.get_active() :
			self.Toolbar.hide()
			widget.set_label("툴바 보이기")
		else :
			self.Toolbar.show()
			widget.set_label("툴바 감추기")

	def on_show_menubar (self, widget) :
		if not widget.get_active() :
			self.Menubar.hide()
		else :
			self.Menubar.show()

	def on_show_toolbar (self, widget) :
		if not widget.get_active() :
			self.Toolbar.hide()
		else :
			self.Toolbar.show()

	def on_set_background_logo (self, parm1, parm2) :

		if self.NOTEBOOK.get_n_pages() < 1 :
			self.addLogo()
		else :
			pass

	def on_test (self, parm1, parm2) :
		print time.time(), "------------------------------------------"
		print parm1
		print parm2.type

		__type = parm2.type

		if __type is gtk.gdk.KEY_RELEASE :
			print parm2.keyval
			print parm2.string
			print parm2.group
			print parm2.hardware_keycode

	#############################################################
	# EVENT HANDLER
	def on_fileSelectionDialog (self, widget) :
		Dialog.FileSelectionDialog(self)

	def on_fontSelectionDialog (self, widget) :
		Dialog.FontSelectionDialog( \
			self.xml, self.LIST_TAB[self.NOTEBOOK.get_current_page()])

	def on_preference (self, widget) :
		Dialog.Preference(self.GCONF_CLIENT)

	def on_about (self, widget) :
		Dialog.About()

	def on_insert_vim (self, widget) :
		self.addVim()

	def on_insert_console (self, widget) :
		self.addConsole()

	def on_remove_page (self, widget) :
		current_page = self.NOTEBOOK.get_current_page()
		tab = self.LIST_TAB[current_page]
		tab.VTE.exit()
		STATUSBAR.clean()

	def on_font_decrease (self, widget) :
		try :
			tab = self.LIST_TAB[self.NOTEBOOK.get_current_page()]
		except :
			return

		tab.VTE.decrease_font()

	def on_font_increase (self, widget) :
		try :
			tab = self.LIST_TAB[self.NOTEBOOK.get_current_page()]
		except :
			return

		tab.VTE.increase_font()

	def on_next_tab (self, widget) :
		self.NOTEBOOK.next_page()

	def on_previous_tab (self, widget) :
		self.NOTEBOOK.prev_page()

	def on_change_title (self, widget) :
		current_page = self.NOTEBOOK.get_current_page()

		__title = self.LIST_TAB[current_page].VTE.get_title()

		self.set_title(__title)
		self.LIST_TAB[current_page].INSTANCE_LABEL.set_label(__title)

	def set_title (self, strings) :
		self.WIDGET_SELF.set_title("%s : VIM-PYTHON" % strings)

	#------------------------------------------------------------
	# Accel HANDLER
	def ac_font_decrease (self, parm1, parm2, parm3, parm4) :
		try :
			tab = self.LIST_TAB[self.NOTEBOOK.get_current_page()]
		except :
			return

		tab.VTE.decrease_font()

	def ac_font_increase (self, parm1, parm2, parm3, parm4) :
		try :
			tab = self.LIST_TAB[self.NOTEBOOK.get_current_page()]
		except :
			return

		tab.VTE.increase_font()

	def ac_insert_vim (self, parm1, parm2, parm3, parm4) :
		self.addVim()

	def ac_insert_console (self, parm1, parm2, parm3, parm4) :
		self.addConsole()

	def ac_fileSelectionDialog  (self, parm1, parm2, parm3, parm4) :
		Dialog.FileSelectionDialog(self)

	def ac_next_tab (self, parm1, parm2, parm3, parm4) :
		self.NOTEBOOK.next_page()

	def ac_previous_tab (self, parm1, parm2, parm3, parm4) :
		self.NOTEBOOK.prev_page()

	def ac_rotate_tab (self, parm1, parm2, parm3, parm4) :
		print self.NOTEBOOK.next_page()

	#############################################################
	# etc method.
	def activate_accelerator (self, parm1) :
		# set accelerator
		__key = gtk.accelerator_parse("<Control>Page_Up")
		self.AccelGrp.connect_group(__key[0], __key[1], \
			gtk.ACCEL_VISIBLE, self.ac_next_tab)

		__key = gtk.accelerator_parse("<Control>Page_Down")
		self.AccelGrp.connect_group(__key[0], __key[1], \
			gtk.ACCEL_VISIBLE, self.ac_previous_tab)

		__key = gtk.accelerator_parse("<Control>equal")
		self.AccelGrp.connect_group(__key[0], __key[1], \
			gtk.ACCEL_VISIBLE, self.ac_font_increase)

		__key = gtk.accelerator_parse("<Control>minus")
		self.AccelGrp.connect_group(__key[0], __key[1], \
			gtk.ACCEL_VISIBLE, self.ac_font_decrease)

		__key = gtk.accelerator_parse("<Control><Shift>N")
		self.AccelGrp.connect_group(__key[0], __key[1], \
			gtk.ACCEL_VISIBLE, self.ac_insert_vim)

		__key = gtk.accelerator_parse("<Control><Shift>O")
		self.AccelGrp.connect_group(__key[0], __key[1], \
			gtk.ACCEL_VISIBLE, self.ac_fileSelectionDialog)

		__key = gtk.accelerator_parse("<Control><Shift>Z")
		self.AccelGrp.connect_group(__key[0], __key[1], \
			gtk.ACCEL_VISIBLE, self.ac_insert_console)

	def addLogo (self) :
		Logo = gtk.Image()
		Logo.set_from_file("vi-python.png")
		Logo.show()

		#self.NOTEBOOK.append_page(Logo)
		tab = TAB.TAB( \
			self.NOTEBOOK, \
			state=self.STATE, \
			without_closebutton=True)

		tab.addWidget(Logo, "브이 VuEE")

		self.IS_LOGO = self.NOTEBOOK.get_current_page()

	def addVim (self, filename=str(), openInThisPage=False) :

		if type(self.IS_LOGO) is int :
			self.NOTEBOOK.remove_page(self.IS_LOGO)
			self.IS_LOGO = False

		VT = TAB.VTE_VIM(filename=filename)
		VT.make()

		if not openInThisPage :
			tab = TAB.TAB(self.NOTEBOOK, state=self.STATE)

			if filename : # add label
				__label = Label.TabWithCloseForVim( \
					filename=filename, state=self.STATE)

				tab.addLabel(__label)

			tab.addVTE(VT)

			self.LIST_TAB.append(tab)
		else :
			tab = self.LIST_TAB[self.NOTEBOOK.get_current_page()]

			if tab.VTE.VTE_TYPE != TAB.VTE_TYPE_VIM :
				self.addVim(filename)
			else :
				tab.VTE.VTE.feed_child(":e %s\n" % filename)
				tab.INSTANCE_LABEL.set_label(filename)

		# set window title
		#self.set_title(tab.INSTANCE_LABEL.get_label())
		VT.VTE.connect("window-title-changed", self.on_change_title)

	def addConsole (self) :

		if type(self.IS_LOGO) is int :
			self.NOTEBOOK.remove_page(self.IS_LOGO)
			self.IS_LOGO = False

		VT = TAB.VTE_CONSOLE()
		VT.make()

		tab = TAB.TAB(self.NOTEBOOK, state=self.STATE)
		tab.STR_TAB_NAME = "Console"
		tab.addVTE(VT)

		self.LIST_TAB.append(tab)

		# set window title
		#self.set_title(tab.INSTANCE_LABEL.get_label())

		VT.VTE.connect("window-title-changed", self.on_change_title)

if __name__ == "__main__" :

	# check whether the gconf schema was installed, if not install it.
	Conf.verify()

	GLADEFILE = "vi-python.glade"
	app = main()

	try :
		gtk.main()
	except :
		sys.exit(1)
	else :
		sys.exit(0)

