/// @file	DefIme.cpp 
/// @brief	IME  ҽ
#include <windows.h>
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
#include <tchar.h>

#define MAX_LOADSTRING 100

//  Դϴ.
HINSTANCE	g_hInst;							///<  νϽԴϴ.
HWND		g_hWndMain;							///< Main Wnd
TCHAR szTitle[MAX_LOADSTRING] = "IME_Src";		///<  ǥ ؽƮԴϴ.
TCHAR szWindowClass[MAX_LOADSTRING] = "IME_Src";///< ⺻ â Ŭ ̸Դϴ.

//  ڵ ⿡  ִ Լ  Դϴ.
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

/// @brief	winmain
int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
 	// TODO: ⿡ ڵ带 Էմϴ.
	MSG msg;

	//  ڿ ʱȭմϴ.
	MyRegisterClass(hInstance);

	//  α׷ ʱȭ մϴ.
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	// ⺻ ޽ Դϴ.
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return (int) msg.wParam;
}



/// @brief	â Ŭ մϴ.
///
/// Windows 95 ߰ 'RegisterClassEx' Լ 
/// ش ڵ尡 Win32 ý۰ ȣȯǵ
/// Ϸ 쿡  Լ մϴ.  Լ ȣؾ
/// ش  α׷ 
/// 'ùٸ '     ֽϴ.
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, (LPCTSTR)IDI_APPLICATION);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= (LPCTSTR)NULL;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_APPLICATION);

	return RegisterClassEx(&wcex);
}

/// @brief	νϽ ڵ ϰ  â ϴ.
///
///  Լ  νϽ ڵ   ϰ
///  α׷ â   ǥմϴ.
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   g_hInst = hInstance; // νϽ ڵ   մϴ.

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }
   g_hWndMain = hWnd;

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}


void GetCandi(const WPARAM & wParam);
void GetChar(const char ch);
void GetCompString();
void GetCompResult();
void SetComWindow(const int & x, const int & y);


TCHAR	g_buf[4096] = {0, };		///< ϼ ڿ.
TCHAR	g_comBuf[64] = {0, };		///<  .
char	g_canBuf[128] = {0, };		///< ĺ 
int		g_canIndex=0;				///<  ĺ ġ
int		g_canMaxCnt=0;				///<  ĺ  ִ ټ

/// @brief	 â ޽ óմϴ.
///
/// WM_PAINT	-  â ׸ϴ.\n
/// WM_DESTROY	-  ޽ Խϰ ȯմϴ.\n
/// WM_IME_COMPOSITION	-   ޼ \n
/// WM_IME_NOTIFY		- ĺ  ó(ڵ..)
/// WM_KEYDOWN			- ĺ(ڵ..)   ֱ ٲٱ.
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message) 
	{
	case WM_PAINT:				//  ⿡ ׸ ڵ带 ߰մϴ.
		hdc = BeginPaint(hWnd, &ps);
		TextOut(hdc, 0, 0, g_buf, lstrlen(g_buf));
		TextOut(hdc, 0, 50, g_comBuf, lstrlen(g_comBuf));
		TextOut(hdc, 0, 100, g_canBuf, lstrlen(g_canBuf));
		EndPaint(hWnd, &ps);
		break;
	
	case WM_DESTROY:			// α׷ 
		PostQuitMessage(0);
		break;

	case WM_CHAR:				// ϼ ѱ ޼.
		GetChar((const char)wParam);
		InvalidateRect(hWnd, NULL, TRUE);	// ȭ ٽ ׸.
		break;

	case WM_IME_COMPOSITION:	//   ޼.
		//   ó
		if(lParam & GCS_COMPSTR) {
			GetCompString();

			//  츦 (  * 10)ŭ ̵Ų.
			SetComWindow((int)strlen(g_buf)*10, 10);
			InvalidateRect(hWnd, NULL, TRUE);	// ȭ ٽ ׸.
		}

		//  Ϸ  ó.
		if(lParam & GCS_RESULTSTR) {
			GetCompResult();

			//  츦 (  * 10)ŭ ̵Ų.
			SetComWindow((int)strlen(g_buf)*10, 10);
			InvalidateRect(hWnd, NULL, TRUE);	// ȭ ٽ ׸.
			return 0;
		}
		break;

	// IME ĺ  ó(ڵ..)
	case WM_IME_NOTIFY:
		// ĺ  ó Ѵ.
		GetCandi(wParam);

		DefWindowProc(hWnd, message, wParam, lParam);	// 찡 ϴ ĺ 츦 ׷ֱ ȣ.
		InvalidateRect(hWnd, NULL, TRUE);	// ȭ ٽ ׸.
		break;

	case WM_KEYDOWN:    // Ű .
		// ĺ 찡    
		if(g_canBuf[0]==0)
			break;

		// ĺ 찡  ְ Ű  
		if(wParam == VK_PROCESSKEY){
			if((lParam & 0xff0000) == 0x4b0000) {	// ʹŰ
				if(9 <= g_canIndex) {
					g_canIndex -= 9;	//  ĺ ڵ(..)
				}
			}

			if((lParam & 0xff0000) == 0x4d0000) { //  Ű
				if(g_canIndex+9 < g_canMaxCnt) {
					g_canIndex += 9;	//  ĺ ڵ(..)
				}
			}
		}
		break;

	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

/// @brief	ĺ ڸ Ͽ g_canBuf  ִ´.
/// @param	wParam		 ޼.
///  url http://sonhy1.tistory.com/52
void GetCandi(const WPARAM & wParam)
{
	int				i;
	int				bufLen;			// ۱
	LPCANDIDATELIST lpCandList;		// ĺ Ʈ

	HIMC hIMC = ImmGetContext(g_hWndMain);

	switch (wParam) {
		case IMN_OPENCANDIDATE:		// ó .;;;;
			if((bufLen = ImmGetCandidateList(hIMC, 0, NULL, 0)) == 0) {
				break;
			}

			memset(g_canBuf, 0x00, sizeof(g_canBuf)); //  ĺڰ   ʱȭ
			g_canIndex = 0;
			g_canMaxCnt = bufLen;

			// ̸ŭ ޸ 
			lpCandList = (LPCANDIDATELIST)new char[bufLen];

			// Ҵ  Ʈ ޴´.
			ImmGetCandidateList(hIMC, 0, lpCandList, bufLen);

			for(i=0 ; i < 9; ++i) {	// ѹ 9 ̴ϱ 9޴´.
				WORD canIndex = i+g_canIndex;
				if(lpCandList->dwCount <= canIndex) {
					break;
				}
				LPSTR lpStr = (LPSTR)lpCandList + lpCandList->dwOffset[canIndex];
				// ھ
				strcpy(g_canBuf + strlen(g_canBuf), lpStr);
				// ĺ ڿ ִ´;.
			}

			delete lpCandList;
			break;

	case IMN_CLOSECANDIDATE:  //  Ʈ .
		g_canIndex = 0;
		g_canBuf[0] = 0;
		g_canMaxCnt = 0;
		break;

	case IMN_CHANGECANDIDATE:	// Ű  ο  ٲٱ
		memset(g_canBuf, 0x00, sizeof(g_canBuf)); //  ĺڰ   ʱȭ
		if(!(bufLen = ImmGetCandidateList(hIMC, 0, NULL, 0))) {
			break;
		}

		lpCandList = (LPCANDIDATELIST)new char[bufLen];

		//lpCandList  ´;.
		ImmGetCandidateList(hIMC, 0, lpCandList, bufLen);
		
		// ѹ 9 ̴ϱ 9޴´.
		for(i=0 ; i < 9; ++i) {
			WORD canIndex = i+g_canIndex;
			if(lpCandList->dwCount <= canIndex) {
				break;
			}

			// ھ
			LPSTR lpStr = (LPSTR)lpCandList + lpCandList->dwOffset[canIndex];
			
			// ĺ ڿ ִ´
			strcpy(g_canBuf + strlen(g_canBuf), lpStr);
		}

		delete lpCandList;
		break;
	}

	ImmReleaseContext(g_hWndMain, hIMC);
}

// @brief	ϼ ڸ g_buf ´.
void GetChar(const char ch)
{
	size_t len = strlen(g_buf);
	g_buf[len] = ch;
	g_buf[len+1] = 0;
}

// @brief	 ڸ Ͽ g_comBuf ִ´.
void GetCompString()
{
	HIMC	hImc;
	size_t	len;

	hImc = ImmGetContext(g_hWndMain);

	//  ڱ̸ Ѵ..
	len = ImmGetCompositionString(hImc, GCS_COMPSTR, NULL, 0);

	//  ڸ ´.
	ImmGetCompositionString(hImc, GCS_COMPSTR, g_comBuf, sizeof(g_comBuf));
	g_comBuf[len] = 0;
	
	ImmReleaseContext(g_hWndMain, hImc);
}

/// @brief	 ϼ ڸ ´.
void GetCompResult()
{
	char *	pBuf = NULL;
	HIMC	hImc;
	DWORD	len;

	hImc = ImmGetContext(g_hWndMain);

	//  ϼ ڱ̸ Ѵ..
	len = ImmGetCompositionString(hImc, GCS_RESULTSTR, NULL, 0);
	pBuf = new char[len+1];

	//  ϼ ´.
	ImmGetCompositionString(hImc, GCS_RESULTSTR, pBuf, len);

	ImmReleaseContext(g_hWndMain, hImc);

	pBuf[len] = 0;
	// ϼ ڿ ߰Ѵ.
	strcat(g_buf, pBuf);
	delete [] pBuf;
}

/// @brief	  ġ Ѵ.
void SetComWindow(const int & x, const int & y)
{
	HIMC	hImc;

	COMPOSITIONFORM CompForm;
	
	CompForm.dwStyle = CFS_POINT;
	
	CompForm.ptCurrentPos.x = x;		// x
	CompForm.ptCurrentPos.y = y;		// y
	
	hImc = ImmGetContext(g_hWndMain);

	//   ġ Ѵ.
	ImmSetCompositionWindow(hImc, &CompForm);

	ImmReleaseContext(g_hWndMain, hImc);
}
