/*
The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.

Alternatively, the contents of this file may be used under the
terms of the GNU General Public License Version 2 or later (the
"GPL"), in which case the provisions of the GPL are applicable 
instead of those above.

Copyright (C) 2003 Tomas Styblo <tripie@cpan.org>
*/

var mozex_default_tmpdir = "/tmp";  /* unix */
var mozex_dir_separator = '/';      /* unix */
var mozex_os = 'unix';              /* unix */
if (window.navigator.platform.toLowerCase().indexOf("win") != -1) {
    mozex_default_tmpdir = "C:\\windows\\temp";     /* windows */
    mozex_dir_separator = '\\';                     /* windows */
    mozex_os = 'win';                               /* windows */
}

var mozex_default_port_ftp = 21;
var mozex_default_port_telnet = 23;
var mozex_default_port_news = 119;
var mozex_alert_error = "mozex error: ";
var mozex_tmpfiles_maxage = 3600 * 24; // in seconds
// var mozex_tmpfiles_maxage = 3600; // in seconds

var mozex_document = null;
var mozex_textarea = null;
var mozex_link_node = null;
var mozex_src_filename = null;

function mozexInit(evt) {
    window.removeEventListener("load", mozexInit, true);
    getBrowser().addEventListener("mousedown", mozexHandleMouseDown, true);
    getBrowser().addEventListener("mouseup", mozexHandleMouseIntercept, true);
    getBrowser().addEventListener("click", mozexHandleMouseIntercept, true);
}

function mozexGetPrefTmpdir() {
    var dir = mozexReadPref("general.tmpdir");
    if (dir == null || dir.length == 0) {
        dir = mozex_default_tmpdir;
    }
    
    if (! mozexExistsFile(dir)) {
        mozexError("temporary directory '" + dir + "' does not exist");
        return null;
    }
    return dir;
}

function mozexGetPrefCommand(name) {
    var cmd = mozexReadPref("command" + '.' + name);
    if (cmd == null || cmd.length == 0) {
        mozexError("no '" + name + "' command is set");
        return null;
    }
    else {
        return cmd;
    }
}

function mozexTmpFilenameTextarea(textarea_node) {
    var tmpdir = mozexGetPrefTmpdir();
    if (tmpdir) {
        var d = new Date();
        return tmpdir + mozex_dir_separator + "mozex.textarea." + 
           hex_md5(textarea_node.ownerDocument.URL + ':' + 
                   textarea_node.getAttribute("name")) + ".txt";
    }
    else {
        return null;
    }
}

function mozexTmpFilenameSource(url) {
    var tmpdir = mozexGetPrefTmpdir();
    if (tmpdir) {
        var d = new Date();
        return tmpdir + mozex_dir_separator + "mozex.source." + 
           hex_md5(url) + '.' + d.getTime() + ".html";
    }
    else {
        return null;
    }
}

function mozexHandleMouseDown(evt) {
    var elem_type = null;
    var link_type = null;

    mozex_document = evt.originalTarget.ownerDocument;
	for(var node = evt.originalTarget; node != null; node = node.parentNode) {
		if(node.nodeType == Node.ELEMENT_NODE) {
            elem_type = node.localName.toUpperCase();
            if (elem_type == "TEXTAREA") {
                mozex_textarea = node;
                break;
            }
            else if (elem_type == "A") {
                link_type = mozexGetProtocol(node);
                mozex_link_node = node;
                break;
            }
        }
    }

    if (evt.button == 0 && link_type != null) {
        // left mouse button - intercept
        if (link_type == "mailto" && mozexReadPref("intercept.mailto")) {
            evt.preventDefault(); evt.stopPropagation();
            mozexSendEmail();
            return false;
        }
        else if (link_type == "ftp" && mozexReadPref("intercept.ftp")) {
            evt.preventDefault(); evt.stopPropagation();
            mozexFTPClient();
            return false;
        }
        else if (link_type == "telnet" && mozexReadPref("intercept.telnet")) {
            evt.preventDefault(); evt.stopPropagation();
            mozexTelnetClient();
            return false;
        }
        else if (link_type == "news" && mozexReadPref("intercept.news")) {
            evt.preventDefault(); evt.stopPropagation();
            mozexNewsClient();
            return false;
        }
        else if (link_type == "ed2k") {
            evt.preventDefault(); evt.stopPropagation();
            mozexED2KClient();
            return false;
        }
    }
    else if (evt.button == 2) {
        // right mouse button - popup menu
        /* show textarea entries ? */
        document.getElementById("mozex-edit-textarea").setAttribute('disabled', 
            !(elem_type == "TEXTAREA"));
        document.getElementById("mozex-fill-textarea").setAttribute('disabled', 
            !(elem_type == "TEXTAREA" && 
                mozexExistsFile(mozexTmpFilenameTextarea(mozex_textarea))));

        /* show link handlers ? */
        document.getElementById("mozex-link-download").setAttribute('disabled', 
            (link_type == null || link_type == "mailto" || 
             link_type == "telnet" || link_type == "news"));
            
        document.getElementById("mozex-link-mailto").setAttribute('disabled', 
            !(link_type == "mailto"));
        document.getElementById("mozex-link-ftp").setAttribute('disabled', 
            !(link_type == "ftp"));
        document.getElementById("mozex-link-telnet").setAttribute('disabled',
            !(link_type == "telnet"));
        document.getElementById("mozex-link-news").setAttribute('disabled',
            !(link_type == "news"));
        document.getElementById("mozex-link-ed2k").setAttribute('disabled',
            !(link_type == "ed2k"));
            
        /* show frame source ? */
        document.getElementById("mozex-frame-source").setAttribute('disabled',
            (mozex_document == window._content.document));
    }
}

function mozexHandleMouseIntercept(evt) {
    var elem_type = null;
    var link_type = null;
	for(var node = evt.originalTarget; node != null; node = node.parentNode) {
		if(node.nodeType == Node.ELEMENT_NODE) {
            elem_type = node.localName.toUpperCase();
            if (elem_type == "A") {
                link_type = mozexGetProtocol(node);
                break;
            }
        }
    }

    if (evt.button == 0 && link_type != null) {
        // left mouse button - intercept
        if ((link_type == "mailto" && mozexReadPref("intercept.mailto")) ||
            (link_type == "news" && mozexReadPref("intercept.news")) ||
            (link_type == "telnet" && mozexReadPref("intercept.telnet")) ||
            (link_type == "ftp" && mozexReadPref("intercept.ftp")) ||
            (link_type == "ed2k")) {
            evt.preventDefault(); evt.stopPropagation();
            return false;
        }
    }
}

function mozexViewPageSource() {
    if (! window._content.document) {
        mozexError("page source viewer: no document");
        return;
    }
    
    var url = window._content.document.URL;
    if (url.substring(0, url.indexOf(':')).toLowerCase() == 'file') {
        mozexViewSourceBaseLocal(window._content.document);
    }
    else {
        mozexViewSourceBaseDom(window._content.document);
    }
}

function mozexViewFrameSource() {
    if (! mozex_document) {
        mozexError("frame source viewer: no document");
        return;
    }
    
    var url = mozex_document.URL;
    if (url.substring(0, url.indexOf(':')).toLowerCase() == 'file') {
        mozexViewSourceBaseLocal(mozex_document);
    }
    else {
        mozexViewSourceBaseDom(mozex_document);
    }
}

function mozexPurgeTmpdir() {
    var files = mozexReadDir(mozexGetPrefTmpdir());
    files.QueryInterface(Components.interfaces.nsISimpleEnumerator);
    while (files.hasMoreElements()) {
        var f = files.getNext();
        f.QueryInterface(Components.interfaces.nsIFile);
        var d = new Date();
        if ((f.leafName.substr(0, 5) == "mozex") && 
            (d.getTime() - f.lastModifiedTime > mozex_tmpfiles_maxage * 1000)) {
            // alert("deleting tmpfile: " + f.leafName);
            try {
                f.remove(false);
            }
            catch (e) {
                mozexError("cannot delete temporary file '" + f.path + "': " + e);
            }
        }
    }
}

function mozexViewSourceBaseLocal(doc) {
    if (mozex_os == 'win' && doc.URL.indexOf("file:///") == 0) {
        // windows hack
        mozex_src_filename = doc.URL.substr(8);
    }
    else {
        mozex_src_filename = doc.URL.substr(7);
    }
    mozexSourceEditor();
}

function mozexViewSourceBaseDom(doc) {
    mozexPurgeTmpdir();

    // reuse temporary file
    var file = Components.classes["@mozilla.org/file/local;1"].
               createInstance(Components.interfaces.nsILocalFile);
    var tmpdir = mozexGetPrefTmpdir();
    if (! tmpdir) {
        return;
    }
    mozex_src_filename = mozexTmpFilenameSource(doc.URL);
    file.initWithPath(mozex_src_filename);
    if (file.exists()) {
        try {
            file.remove(false);
        }
        catch (e) {
            mozexError("cannot delete temporary file '" + file.path + "': " + e);
        }
    }

    // initialize the downloader
    var persist = Components.classes["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"].
                  createInstance(Components.interfaces.nsIWebBrowserPersist);
    persist.persistFlags = 1 | 32 | 64 | 512 | 2048;
    try {
        var encode = 4;
        persist.saveDocument(doc, file, null, null, encode, 0);
    }
    catch (e) {
        mozexError("cannot save document '" + doc.URL + "': " + e);
    }
 
    // wait for the completion and then run the editor
    setTimeout("mozexSourceEditor()", 200);
}

function mozexSourceEditor() {
    var esc = {
        't': mozex_src_filename
    };
    mozexRunProgram("view source", mozexGetPrefCommand("source"), esc);
}

function mozexGetProtocol(node) {
    var href = node.getAttribute("href");
    return href.substring(0, href.indexOf(':')).toLowerCase();
}

function mozex_unescape(str) {
    var buf = str.replace(/\+/g, " ");
    buf = decodeURIComponent(buf);
    return buf;
}

function mozexSendEmail() {
    if (mozex_link_node) {
        var href = mozex_link_node.getAttribute("href");
        var addr = href.substr(href.indexOf(':') + 1);
        var subject = "";
        var body = "";
        var cc = "";
        // FIXME: How are '?' and '=' encoded ?
        if (addr.indexOf('?') != -1) {
            var a = addr.split('?', 2);
            addr = mozex_unescape(a[0]);

            // find all key=value pairs
            var pairs = a[1].split('&');
            for (var i = 0; i < pairs.length; i++) {
                var pair = pairs[i].split('=', 2);
                if (pair[0].toLowerCase() == "subject") {
                    subject = mozex_unescape(pair[1]);
                }
                else if (pair[0].toLowerCase() == "body") {
                    body = mozex_unescape(pair[1]);
                }
                else if (pair[0].toLowerCase() == "to") {
                    addr = addr + ", " + mozex_unescape(pair[1]);
                }
                else if (pair[0].toLowerCase() == "cc") {
                    cc = mozex_unescape(pair[1]);
                }
            }
        }
        // alert("addr: " + addr);
        // alert("subject: " + subject);
        if (addr.length == 0) {
            mozexError("email address is empty");
        }
        else {
            // convert newline separators in body
            if (body.length > 0) {
                if (mozex_os == "unix" && body.search(/\r\n/) != -1) {
                    body = body.replace(/\r\n/g, "\n");
                }
                else if (mozex_os == "win" && body.search(/[^\r]\n/) != -1) {
                    body = body.replace(/([^\r])\n/g, "$1\r\n");
                }
            }
            
            // run the mailer
            var esc = {
                'a': addr,
                'A': encodeURIComponent(addr),
                's': (subject.length > 0 ? subject : ""),
                'S': (subject.length > 0 ? encodeURIComponent(subject) : ""),
                'c': (cc.length > 0 ? cc : ""),
                'C': (cc.length > 0 ? encodeURIComponent(cc) : ""),
                'b': (body.length > 0 ? body : ""),
                'B': (body.length > 0 ? encodeURIComponent(body) : "")
            };
            mozexRunProgram("send email (mailto)", mozexGetPrefCommand("mailer"), esc);
        }
    }
    else {
        mozexError("no link node found");
    }
}

function mozexNewsClient() {
    if (mozex_link_node) {
        var href = mozex_link_node.getAttribute("href");
        var res = mozexParseUrl(href);
        // for (var x in res) { alert(x + ':' + res[x]); }
        if (res.host.length == 0) {
            mozexError("news host is empty");
        }
        else {
            // run the news client
            var esc = {
                'h': res.host,
                'o': (res.port == -1 ? mozex_default_port_news : res.port),
                'u': res.user,
                'p': res.pass,
                'g': res.path
            };
            mozexRunProgram("news client", mozexGetPrefCommand("news"), esc);
        }
    }
    else {
        mozexError("no link node found");
    }
}

function mozexTelnetClient() {
    if (mozex_link_node) {
        var href = mozex_link_node.getAttribute("href");
        var res = mozexParseUrl(href);
        // for (var x in res) { alert(x + ':' + res[x]); }
        if (res.host.length == 0) {
            mozexError("telnet host is empty");
        }
        else {
            // run the telnet client
            var esc = {
                'h': res.host,
                'o': (res.port == -1 ? mozex_default_port_telnet : res.port),
                'u': res.user,
                'p': res.pass
            };
            mozexRunProgram("telnet client", mozexGetPrefCommand("telnet"), esc);
        }
    }
    else {
        mozexError("no link node found");
    }
}

function mozexED2KClient() {
    if (mozex_link_node) {
        var href = mozex_link_node.getAttribute("href");
        // run the ed2k client
        var esc = {
            'r': href
        };
        mozexRunProgram("ed2k client", mozexGetPrefCommand("ed2k"), esc);
    }
    else {
        mozexError("no link node found");
    }
}

function mozexFTPClient() {
    if (mozex_link_node) {
        var href = mozex_link_node.getAttribute("href");
        var res = mozexParseUrl(href);
        // for (var x in res) { alert(x + ':' + res[x]); }
        if (res.host.length == 0) {
            mozexError("FTP host is empty");
        }
        else {
            // run the FTP client
            var esc = {
                'h': res.host,
                'o': (res.port == -1 ? mozex_default_port_ftp : res.port),
                'u': res.user,
                'p': res.pass,
                'l': res.path
            };
            mozexRunProgram("FTP client", mozexGetPrefCommand("ftp"), esc);
        }
    }
    else {
        mozexError("no link node found");
    }
}

function mozexDownload() {
    if (mozex_link_node) {
        var href = mozex_link_node.getAttribute("href");
        if (href.length == 0) {
            mozexError("url is empty");
        }
        else {
            if (href.indexOf("://") == -1) {
                // convert to absolute URL
                var base = mozex_document.URL;
                if (base.charAt(base.length - 1) == '/') {
                    href = base + href;
                }
                else {
                    if (href.charAt(0) == '/') {
                        href = base.substring(0, 
                            base.indexOf('/', base.indexOf("//") + 2)) + href;
                    }
                    else {
                        href = base.substring(0, base.lastIndexOf('/')) + '/' + href;
                    }
                }
            }
            // run the downloader
            var esc = {
                'r': href
            };
            mozexRunProgram("download", mozexGetPrefCommand("download"), esc);
        }
    }
    else {
        mozexError("no link node found");
    }
}

function mozexRunProgram(context, cmd, esc) {
    if (cmd == null) {
        return false; // no command is set
    }
    
    var args = new Array();
    var scmd = cmd.split(/\s+/);
    var executable = scmd.shift();

    if (executable.length == 0) {
        mozexError(context + ": no executable in command");
        return false;
    }
    
    for (var i = 0; i < scmd.length; i++) {
        var param = scmd[i];
        var buf = "";
        if (param.length == 0) {
            continue;
        }
        for (var e = 0; e < param.length; e++) {
            var c = param[e];
            if (c == '%') {
                var a = param[++e];
                if (esc[a] === undefined) {
                    mozexError(context + ": unknown escape in command '" + cmd + "': %" + a);
                    return false;
                }
                else {
                    buf += esc[a];
                }
            }
            else {
                buf += c;
            }
        }
        args.push(buf);
    }

    try {
        var exec = Components.classes["@mozilla.org/file/local;1"].
                   createInstance(Components.interfaces.nsILocalFile);
        var pr = Components.classes["@mozilla.org/process/util;1"].
                 createInstance(Components.interfaces.nsIProcess);
        var path = null;

        // $PATH stuff (only on UNIX)
        if (mozex_os == 'unix') {
            try {
                path = pr.getEnvironment("PATH").split(":");
            } 
            catch (e) {
                // do nothing
            }
        }

        // If executable is an absolute path, run it or fail.  If not, then
        // look for it in $PATH.  FIXME: How do you tell portably if a path is
        // absolute?
        if (executable.charAt(0) == "/" || path == null) {
            exec.initWithPath(executable);
            if (! exec.exists()) {
                mozexError(context + ": executable '" + executable + "' does not exist.");
                return false;
            }
        } 
        else {
            var found = false;
            for (i = 0; i < path.length; i++) {
                exec.initWithPath(path[i]);
                exec.appendRelativePath(executable);
                if (exec.exists()) {
                    found = true;
                    break;
                }
            }
            if (!found) {
                mozexError(context + ": could not find '" + executable + "' in path.");
                return false;
            }
        }

        pr.init(exec);
        pr.run(false /* don't block */, args, args.length);
    }
    catch (e) {
        mozexError(context + ": cannot run executable '" + 
                   executable + "' (args: " + args + "): " + e);
        return false;
    }
    // alert(pr.pid); /* pid is not implemented :((( */
    return true;
}

function mozexEditTextarea() {
    mozexPurgeTmpdir();
    
    var tmpfile = mozexTmpFilenameTextarea(mozex_textarea);
    if (! tmpfile) {
        return;
    }

    if (mozex_textarea) {
        if (mozexExistsFile(tmpfile)) {
            if (confirm("mozex: This textarea already is being edited.\n" + 
                          "Do you want to start another instance of the editor ?\n" + 
                          "All data written in the previous instance will be lost.")) {
                mozexDeleteFile(tmpfile);
            }
            else {
                return;
            }
        }
	// XXX
        //alert(mozex_textarea.value);
        if (mozexWriteFile(mozex_textarea.value, tmpfile)) {
            // run the editor
            var esc = {
                't': tmpfile
            };
            if (! mozexRunProgram("edit textarea", mozexGetPrefCommand("textarea"), esc)) {
                mozexDeleteFile(tmpfile);
            }
        }
    }
    else {
        mozexError("no textarea node found");
    }
}

function mozexFillTextarea() {
    var tmpfile = mozexTmpFilenameTextarea(mozex_textarea);
    if (! tmpfile) {
        return;
    }

    if (mozex_textarea && mozexExistsFile(tmpfile)) {
        var data = mozexReadFile(tmpfile);
        if (data != null) {
            mozex_textarea.value = data;
            mozexDeleteFile(tmpfile);
        }
    }
}

function mozexReadDir(dirname) {
    var dir = Components.classes["@mozilla.org/file/local;1"].
               createInstance(Components.interfaces.nsILocalFile);
    dir.initWithPath(dirname);
    if (dir.isDirectory()) {
        return dir.directoryEntries;
    }
    else {
        mozexError("path '" + dir + "' is not a directory");
    }
}

function mozexDeleteFile(filename) {
    var file = Components.classes["@mozilla.org/file/local;1"].
               createInstance(Components.interfaces.nsILocalFile);
    file.initWithPath(filename);
    if (file.exists()) {
        try {
            file.remove(false);
        }
        catch (e) {
            mozexError("cannot delete file '" + file.path + "': " + e);
        }
    }
}

function mozexExistsFile(filename) {
    var file = Components.classes["@mozilla.org/file/local;1"].
               createInstance(Components.interfaces.nsILocalFile);
    file.initWithPath(filename);
    return file.exists();
}

function mozexWriteFile(data, filename) {
    try {
        var file = Components.classes["@mozilla.org/file/local;1"].
                   createInstance(Components.interfaces.nsILocalFile);
        file.initWithPath(filename);
        try {
            /* raises an error if the file already exists */
            file.create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0600);
        }
        catch (e) { 
            mozexError("cannot create temporary file '" + filename + "': " + e); 
            return false;
        }
       
        var stream = Components.classes["@mozilla.org/network/file-output-stream;1"].
                     createInstance(Components.interfaces.nsIFileOutputStream);
        var PR_WRONLY = 0x02;
	var scriptableUnicodeConverter = Components.classes["@mozilla.org/intl/scriptableunicodeconverter"].getService();
	var nsIScriptableUnicodeConverter=scriptableUnicodeConverter.QueryInterface(Components.interfaces.nsIScriptableUnicodeConverter);
	nsIScriptableUnicodeConverter.charset="utf-8";
	var localdata=nsIScriptableUnicodeConverter.ConvertFromUnicode(data);
	nsIScriptableUnicodeConverter.Finish();
	
	//alert("after conversion:"+localdata);

        stream.init(file, PR_WRONLY, 0600, 0);
	//stream.write(data, data.length);
	stream.write(localdata, localdata.length);

        stream.flush()
        stream.close();
    } 
    catch (e) {
        mozexError("cannot write to file '" + filename + "':" + e);
        return false;
    }
    return true;
}

function mozexReadFile(filename) {
    var MODE_RDONLY = 0x01;
    var PERM_IRUSR = 00400;
    
    try {
        var file = Components.classes["@mozilla.org/file/local;1"].
                   createInstance(Components.interfaces.nsILocalFile);
        file.initWithPath(filename);
        if (file.exists() && file.isReadable()) {
            var is = Components.classes["@mozilla.org/network/file-input-stream;1"].
                     createInstance(Components.interfaces.nsIFileInputStream);
            is.init(file, MODE_RDONLY, PERM_IRUSR, 0);
            var sis = Components.classes["@mozilla.org/scriptableinputstream;1"].
                createInstance(Components.interfaces.nsIScriptableInputStream);
            sis.init(is);
	    var data = sis.read(sis.available());

	    var scriptableUnicodeConverter = Components.classes["@mozilla.org/intl/scriptableunicodeconverter"].getService();
	    var nsIScriptableUnicodeConverter=scriptableUnicodeConverter.QueryInterface(Components.interfaces.nsIScriptableUnicodeConverter);
	    nsIScriptableUnicodeConverter.charset="utf-8";
	    var ucsdata=nsIScriptableUnicodeConverter.ConvertToUnicode(data);
	    
            sis.close();
            is.close();
            return ucsdata;
            //return data;
        }
        else {
            mozexError("temporary file '" + filename + "' does not exist or is not readable");
            return null;
        }
    }
    catch (e) {
        mozexError("cannot read from temporary file '" + filename + "': " + e);
    }
    return null;
}

function mozexParseUrl(url) {
    var parser = Components.classes["@mozilla.org/network/url-parser;1?auth=maybe"].
        createInstance(Components.interfaces.nsIURLParser);
    try {
        var proto_pos = new Number();
        var proto_len = new Number();
        var auth_pos = new Number();
        var auth_len = new Number();
        var path_pos = new Number();
        var path_len = new Number();
        parser.parseURL(url, url.length, proto_pos, proto_len, 
            auth_pos, auth_len, path_pos, path_len);
    
        var res = {
            proto: null, user: null, pass: null, host: null, port: null, path: null
        };

        /* protocol, path */
        res.proto = url.substr(proto_pos.value, proto_len.value);
        res.path = url.substr(path_pos.value, path_len.value);

        /* username, password, hostname, port */
        var user_pos = new Number();
        var user_len = new Number();
        var pass_pos = new Number();
        var pass_len = new Number();
        var host_pos = new Number();
        var host_len = new Number();
        var port = new Number();
        var auth = url.substr(auth_pos.value, auth_len.value);
        parser.parseAuthority(auth, auth.length,
            user_pos, user_len, pass_pos, pass_len, host_pos, host_len, port);
        res.user = auth.substr(user_pos.value, user_len.value);
        res.pass = auth.substr(pass_pos.value, pass_len.value);
        res.host = auth.substr(host_pos.value, host_len.value);
        res.port = port.value;
        return res;
    }
    catch (e) {
        mozexError("cannot parse URL: '" + url + "': " + e);
        return null;
    }
}

function mozexError(msg) {
    alert(mozex_alert_error + msg);
}

/* Run run run */
window.addEventListener("load", mozexInit, true);

